// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class RetrieverConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Retriever>
{
	private static readonly System.Text.Json.JsonEncodedText VariantKnn = System.Text.Json.JsonEncodedText.Encode("knn");
	private static readonly System.Text.Json.JsonEncodedText VariantLinear = System.Text.Json.JsonEncodedText.Encode("linear");
	private static readonly System.Text.Json.JsonEncodedText VariantPinned = System.Text.Json.JsonEncodedText.Encode("pinned");
	private static readonly System.Text.Json.JsonEncodedText VariantRescorer = System.Text.Json.JsonEncodedText.Encode("rescorer");
	private static readonly System.Text.Json.JsonEncodedText VariantRrf = System.Text.Json.JsonEncodedText.Encode("rrf");
	private static readonly System.Text.Json.JsonEncodedText VariantRule = System.Text.Json.JsonEncodedText.Encode("rule");
	private static readonly System.Text.Json.JsonEncodedText VariantStandard = System.Text.Json.JsonEncodedText.Encode("standard");
	private static readonly System.Text.Json.JsonEncodedText VariantTextSimilarityReranker = System.Text.Json.JsonEncodedText.Encode("text_similarity_reranker");

	public override Elastic.Clients.Elasticsearch.Retriever Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		string? variantType = null;
		object? variant = null;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (reader.ValueTextEquals(VariantKnn))
			{
				variantType = VariantKnn.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.KnnRetriever>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantLinear))
			{
				variantType = VariantLinear.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.LinearRetriever>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantPinned))
			{
				variantType = VariantPinned.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.PinnedRetriever>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantRescorer))
			{
				variantType = VariantRescorer.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.RescorerRetriever>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantRrf))
			{
				variantType = VariantRrf.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.RRFRetriever>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantRule))
			{
				variantType = VariantRule.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.RuleRetriever>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantStandard))
			{
				variantType = VariantStandard.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.StandardRetriever>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantTextSimilarityReranker))
			{
				variantType = VariantTextSimilarityReranker.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.TextSimilarityReranker>(options, null);
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Retriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			VariantType = variantType,
			Variant = variant
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Retriever value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		switch (value.VariantType)
		{
			case null:
				break;
			case "knn":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.KnnRetriever)value.Variant, null, null);
				break;
			case "linear":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.LinearRetriever)value.Variant, null, null);
				break;
			case "pinned":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.PinnedRetriever)value.Variant, null, null);
				break;
			case "rescorer":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.RescorerRetriever)value.Variant, null, null);
				break;
			case "rrf":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.RRFRetriever)value.Variant, null, null);
				break;
			case "rule":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.RuleRetriever)value.Variant, null, null);
				break;
			case "standard":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.StandardRetriever)value.Variant, null, null);
				break;
			case "text_similarity_reranker":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.TextSimilarityReranker)value.Variant, null, null);
				break;
			default:
				throw new System.Text.Json.JsonException($"Variant '{value.VariantType}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.Retriever)}'.");
		}

		writer.WriteEndObject();
	}
}