// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class ResultConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Result>
{
	private static readonly System.Text.Json.JsonEncodedText MemberCreated = System.Text.Json.JsonEncodedText.Encode("created");
	private static readonly System.Text.Json.JsonEncodedText MemberDeleted = System.Text.Json.JsonEncodedText.Encode("deleted");
	private static readonly System.Text.Json.JsonEncodedText MemberNoOp = System.Text.Json.JsonEncodedText.Encode("noop");
	private static readonly System.Text.Json.JsonEncodedText MemberNotFound = System.Text.Json.JsonEncodedText.Encode("not_found");
	private static readonly System.Text.Json.JsonEncodedText MemberUpdated = System.Text.Json.JsonEncodedText.Encode("updated");

	public override Elastic.Clients.Elasticsearch.Result Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberCreated))
		{
			return Elastic.Clients.Elasticsearch.Result.Created;
		}

		if (reader.ValueTextEquals(MemberDeleted))
		{
			return Elastic.Clients.Elasticsearch.Result.Deleted;
		}

		if (reader.ValueTextEquals(MemberNoOp))
		{
			return Elastic.Clients.Elasticsearch.Result.NoOp;
		}

		if (reader.ValueTextEquals(MemberNotFound))
		{
			return Elastic.Clients.Elasticsearch.Result.NotFound;
		}

		if (reader.ValueTextEquals(MemberUpdated))
		{
			return Elastic.Clients.Elasticsearch.Result.Updated;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberCreated.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Result.Created;
		}

		if (string.Equals(value, MemberDeleted.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Result.Deleted;
		}

		if (string.Equals(value, MemberNoOp.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Result.NoOp;
		}

		if (string.Equals(value, MemberNotFound.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Result.NotFound;
		}

		if (string.Equals(value, MemberUpdated.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Result.Updated;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Result)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Result value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Result.Created:
				writer.WriteStringValue(MemberCreated);
				break;
			case Elastic.Clients.Elasticsearch.Result.Deleted:
				writer.WriteStringValue(MemberDeleted);
				break;
			case Elastic.Clients.Elasticsearch.Result.NoOp:
				writer.WriteStringValue(MemberNoOp);
				break;
			case Elastic.Clients.Elasticsearch.Result.NotFound:
				writer.WriteStringValue(MemberNotFound);
				break;
			case Elastic.Clients.Elasticsearch.Result.Updated:
				writer.WriteStringValue(MemberUpdated);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Result)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Result ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Result value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}