// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.RescoreVectorConverter))]
public sealed partial class RescoreVector
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RescoreVector(float oversample)
	{
		Oversample = oversample;
	}
#if NET7_0_OR_GREATER
	public RescoreVector()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public RescoreVector()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RescoreVector(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Applies the specified oversample factor to k on the approximate kNN search
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	float Oversample { get; set; }
}

public readonly partial struct RescoreVectorDescriptor
{
	internal Elastic.Clients.Elasticsearch.RescoreVector Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RescoreVectorDescriptor(Elastic.Clients.Elasticsearch.RescoreVector instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RescoreVectorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.RescoreVector(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.RescoreVectorDescriptor(Elastic.Clients.Elasticsearch.RescoreVector instance) => new Elastic.Clients.Elasticsearch.RescoreVectorDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.RescoreVector(Elastic.Clients.Elasticsearch.RescoreVectorDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Applies the specified oversample factor to k on the approximate kNN search
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RescoreVectorDescriptor Oversample(float value)
	{
		Instance.Oversample = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.RescoreVector Build(System.Action<Elastic.Clients.Elasticsearch.RescoreVectorDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.RescoreVectorDescriptor(new Elastic.Clients.Elasticsearch.RescoreVector(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}