// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class RefreshConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Refresh>
{
	private static readonly System.Text.Json.JsonEncodedText MemberFalse = System.Text.Json.JsonEncodedText.Encode("false");
	private static readonly System.Text.Json.JsonEncodedText MemberTrue = System.Text.Json.JsonEncodedText.Encode("true");
	private static readonly System.Text.Json.JsonEncodedText MemberWaitFor = System.Text.Json.JsonEncodedText.Encode("wait_for");

	public override Elastic.Clients.Elasticsearch.Refresh Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberFalse))
		{
			return Elastic.Clients.Elasticsearch.Refresh.False;
		}

		if (reader.ValueTextEquals(MemberTrue))
		{
			return Elastic.Clients.Elasticsearch.Refresh.True;
		}

		if (reader.ValueTextEquals(MemberWaitFor))
		{
			return Elastic.Clients.Elasticsearch.Refresh.WaitFor;
		}

		if (reader.TokenType is not System.Text.Json.JsonTokenType.String)
		{
			throw new System.Text.Json.JsonException($"Unknown member of type '{reader.TokenType}' for enum '{nameof(Elastic.Clients.Elasticsearch.Refresh)}'.");
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberFalse.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Refresh.False;
		}

		if (string.Equals(value, MemberTrue.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Refresh.True;
		}

		if (string.Equals(value, MemberWaitFor.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Refresh.WaitFor;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Refresh)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Refresh value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Refresh.False:
				writer.WriteRawValue(MemberFalse.EncodedUtf8Bytes);
				break;
			case Elastic.Clients.Elasticsearch.Refresh.True:
				writer.WriteRawValue(MemberTrue.EncodedUtf8Bytes);
				break;
			case Elastic.Clients.Elasticsearch.Refresh.WaitFor:
				writer.WriteStringValue(MemberWaitFor);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Refresh)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Refresh ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Refresh value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}