// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.RankConverter))]
public sealed partial class Rank
{
	internal string? VariantType { get; set; }
	internal object? Variant { get; set; }
#if NET7_0_OR_GREATER
	public Rank()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public Rank()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Rank(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The reciprocal rank fusion parameters
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RrfRank? Rrf { get => GetVariant<Elastic.Clients.Elasticsearch.RrfRank>("rrf"); set => SetVariant("rrf", value); }

	public static implicit operator Elastic.Clients.Elasticsearch.Rank(Elastic.Clients.Elasticsearch.RrfRank value) => new Elastic.Clients.Elasticsearch.Rank { Rrf = value };

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private T? GetVariant<T>(string type)
	{
		if (string.Equals(VariantType, type, System.StringComparison.Ordinal) && Variant is T result)
		{
			return result;
		}

		return default;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private void SetVariant<T>(string type, T? value)
	{
		VariantType = type;
		Variant = value;
	}
}

public readonly partial struct RankDescriptor
{
	internal Elastic.Clients.Elasticsearch.Rank Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankDescriptor(Elastic.Clients.Elasticsearch.Rank instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Rank(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.RankDescriptor(Elastic.Clients.Elasticsearch.Rank instance) => new Elastic.Clients.Elasticsearch.RankDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Rank(Elastic.Clients.Elasticsearch.RankDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The reciprocal rank fusion parameters
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankDescriptor Rrf(Elastic.Clients.Elasticsearch.RrfRank? value)
	{
		Instance.Rrf = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The reciprocal rank fusion parameters
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankDescriptor Rrf()
	{
		Instance.Rrf = Elastic.Clients.Elasticsearch.RrfRankDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The reciprocal rank fusion parameters
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankDescriptor Rrf(System.Action<Elastic.Clients.Elasticsearch.RrfRankDescriptor>? action)
	{
		Instance.Rrf = Elastic.Clients.Elasticsearch.RrfRankDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Rank Build(System.Action<Elastic.Clients.Elasticsearch.RankDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.RankDescriptor(new Elastic.Clients.Elasticsearch.Rank(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}