// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.RRFRetrieverConverter))]
public sealed partial class RRFRetriever
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RRFRetriever(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Retriever> retrievers)
	{
		Retrievers = retrievers;
	}
#if NET7_0_OR_GREATER
	public RRFRetriever()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public RRFRetriever()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RRFRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public System.Collections.Generic.ICollection<string>? Fields { get; set; }

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? Filter { get; set; }

	/// <summary>
	/// <para>
	/// Minimum _score for matching documents. Documents with a lower _score are not included in the top documents.
	/// </para>
	/// </summary>
	public float? MinScore { get; set; }

	/// <summary>
	/// <para>
	/// Retriever name.
	/// </para>
	/// </summary>
	public string? Name { get; set; }
	public string? Query { get; set; }

	/// <summary>
	/// <para>
	/// This value determines how much influence documents in individual result sets per query have over the final ranked result set.
	/// </para>
	/// </summary>
	public int? RankConstant { get; set; }

	/// <summary>
	/// <para>
	/// This value determines the size of the individual result sets per query.
	/// </para>
	/// </summary>
	public int? RankWindowSize { get; set; }

	/// <summary>
	/// <para>
	/// A list of child retrievers to specify which sets of returned top documents will have the RRF formula applied to them.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Retriever> Retrievers { get; set; }
}

public readonly partial struct RrfRetrieverDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.RRFRetriever Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RrfRetrieverDescriptor(Elastic.Clients.Elasticsearch.RRFRetriever instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RrfRetrieverDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.RRFRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor<TDocument>(Elastic.Clients.Elasticsearch.RRFRetriever instance) => new Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.RRFRetriever(Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor<TDocument> descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor<TDocument> Fields(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Fields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor<TDocument> Fields(params string[] values)
	{
		Instance.Fields = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor<TDocument> Filter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor<TDocument> Filter(params Elastic.Clients.Elasticsearch.QueryDsl.Query[] values)
	{
		Instance.Filter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor<TDocument> Filter(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum _score for matching documents. Documents with a lower _score are not included in the top documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor<TDocument> MinScore(float? value)
	{
		Instance.MinScore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Retriever name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor<TDocument> Name(string? value)
	{
		Instance.Name = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor<TDocument> Query(string? value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This value determines how much influence documents in individual result sets per query have over the final ranked result set.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor<TDocument> RankConstant(int? value)
	{
		Instance.RankConstant = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This value determines the size of the individual result sets per query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor<TDocument> RankWindowSize(int? value)
	{
		Instance.RankWindowSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of child retrievers to specify which sets of returned top documents will have the RRF formula applied to them.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor<TDocument> Retrievers(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Retriever> value)
	{
		Instance.Retrievers = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of child retrievers to specify which sets of returned top documents will have the RRF formula applied to them.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor<TDocument> Retrievers(params Elastic.Clients.Elasticsearch.Retriever[] values)
	{
		Instance.Retrievers = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of child retrievers to specify which sets of returned top documents will have the RRF formula applied to them.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor<TDocument> Retrievers(params System.Action<Elastic.Clients.Elasticsearch.RetrieverDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Retriever>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.RetrieverDescriptor<TDocument>.Build(action));
		}

		Instance.Retrievers = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.RRFRetriever Build(System.Action<Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.RRFRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct RrfRetrieverDescriptor
{
	internal Elastic.Clients.Elasticsearch.RRFRetriever Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RrfRetrieverDescriptor(Elastic.Clients.Elasticsearch.RRFRetriever instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RrfRetrieverDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.RRFRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor(Elastic.Clients.Elasticsearch.RRFRetriever instance) => new Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.RRFRetriever(Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor Fields(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Fields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor Fields(params string[] values)
	{
		Instance.Fields = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor Filter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor Filter(params Elastic.Clients.Elasticsearch.QueryDsl.Query[] values)
	{
		Instance.Filter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor Filter(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor Filter<T>(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum _score for matching documents. Documents with a lower _score are not included in the top documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor MinScore(float? value)
	{
		Instance.MinScore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Retriever name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor Name(string? value)
	{
		Instance.Name = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor Query(string? value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This value determines how much influence documents in individual result sets per query have over the final ranked result set.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor RankConstant(int? value)
	{
		Instance.RankConstant = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This value determines the size of the individual result sets per query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor RankWindowSize(int? value)
	{
		Instance.RankWindowSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of child retrievers to specify which sets of returned top documents will have the RRF formula applied to them.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor Retrievers(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Retriever> value)
	{
		Instance.Retrievers = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of child retrievers to specify which sets of returned top documents will have the RRF formula applied to them.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor Retrievers(params Elastic.Clients.Elasticsearch.Retriever[] values)
	{
		Instance.Retrievers = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of child retrievers to specify which sets of returned top documents will have the RRF formula applied to them.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor Retrievers(params System.Action<Elastic.Clients.Elasticsearch.RetrieverDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Retriever>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.RetrieverDescriptor.Build(action));
		}

		Instance.Retrievers = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of child retrievers to specify which sets of returned top documents will have the RRF formula applied to them.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor Retrievers<T>(params System.Action<Elastic.Clients.Elasticsearch.RetrieverDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Retriever>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.RetrieverDescriptor<T>.Build(action));
		}

		Instance.Retrievers = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.RRFRetriever Build(System.Action<Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.RrfRetrieverDescriptor(new Elastic.Clients.Elasticsearch.RRFRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}