// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.QueryVectorBuilderConverter))]
public sealed partial class QueryVectorBuilder
{
	internal string? VariantType { get; set; }
	internal object? Variant { get; set; }
#if NET7_0_OR_GREATER
	public QueryVectorBuilder()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public QueryVectorBuilder()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal QueryVectorBuilder(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public Elastic.Clients.Elasticsearch.TextEmbedding? TextEmbedding { get => GetVariant<Elastic.Clients.Elasticsearch.TextEmbedding>("text_embedding"); set => SetVariant("text_embedding", value); }

	public static implicit operator Elastic.Clients.Elasticsearch.QueryVectorBuilder(Elastic.Clients.Elasticsearch.TextEmbedding value) => new Elastic.Clients.Elasticsearch.QueryVectorBuilder { TextEmbedding = value };

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private T? GetVariant<T>(string type)
	{
		if (string.Equals(VariantType, type, System.StringComparison.Ordinal) && Variant is T result)
		{
			return result;
		}

		return default;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private void SetVariant<T>(string type, T? value)
	{
		VariantType = type;
		Variant = value;
	}
}

public readonly partial struct QueryVectorBuilderDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryVectorBuilder Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public QueryVectorBuilderDescriptor(Elastic.Clients.Elasticsearch.QueryVectorBuilder instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public QueryVectorBuilderDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryVectorBuilder(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryVectorBuilderDescriptor(Elastic.Clients.Elasticsearch.QueryVectorBuilder instance) => new Elastic.Clients.Elasticsearch.QueryVectorBuilderDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryVectorBuilder(Elastic.Clients.Elasticsearch.QueryVectorBuilderDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.QueryVectorBuilderDescriptor TextEmbedding(Elastic.Clients.Elasticsearch.TextEmbedding? value)
	{
		Instance.TextEmbedding = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryVectorBuilderDescriptor TextEmbedding(System.Action<Elastic.Clients.Elasticsearch.TextEmbeddingDescriptor> action)
	{
		Instance.TextEmbedding = Elastic.Clients.Elasticsearch.TextEmbeddingDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryVectorBuilder Build(System.Action<Elastic.Clients.Elasticsearch.QueryVectorBuilderDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryVectorBuilderDescriptor(new Elastic.Clients.Elasticsearch.QueryVectorBuilder(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}