// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryRules;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryRules.Json.QueryRulesetListItemConverter))]
public sealed partial class QueryRulesetListItem
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public QueryRulesetListItem(System.Collections.Generic.IReadOnlyDictionary<string, int> ruleCriteriaTypesCounts, string rulesetId, int ruleTotalCount, System.Collections.Generic.IReadOnlyDictionary<string, int> ruleTypeCounts)
	{
		RuleCriteriaTypesCounts = ruleCriteriaTypesCounts;
		RulesetId = rulesetId;
		RuleTotalCount = ruleTotalCount;
		RuleTypeCounts = ruleTypeCounts;
	}
#if NET7_0_OR_GREATER
	public QueryRulesetListItem()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public QueryRulesetListItem()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal QueryRulesetListItem(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A map of criteria type (for example, <c>exact</c>) to the number of rules of that type.
	/// </para>
	/// <para>
	/// NOTE: The counts in <c>rule_criteria_types_counts</c> may be larger than the value of <c>rule_total_count</c> because a rule may have multiple criteria.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyDictionary<string, int> RuleCriteriaTypesCounts { get; set; }

	/// <summary>
	/// <para>
	/// A unique identifier for the ruleset.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string RulesetId { get; set; }

	/// <summary>
	/// <para>
	/// The number of rules associated with the ruleset.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int RuleTotalCount { get; set; }

	/// <summary>
	/// <para>
	/// A map of rule type (for example, <c>pinned</c>) to the number of rules of that type.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyDictionary<string, int> RuleTypeCounts { get; set; }
}