// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryRules.Json;

public sealed partial class QueryRulesetListItemConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.QueryRules.QueryRulesetListItem>
{
	private static readonly System.Text.Json.JsonEncodedText PropRuleCriteriaTypesCounts = System.Text.Json.JsonEncodedText.Encode("rule_criteria_types_counts");
	private static readonly System.Text.Json.JsonEncodedText PropRulesetId = System.Text.Json.JsonEncodedText.Encode("ruleset_id");
	private static readonly System.Text.Json.JsonEncodedText PropRuleTotalCount = System.Text.Json.JsonEncodedText.Encode("rule_total_count");
	private static readonly System.Text.Json.JsonEncodedText PropRuleTypeCounts = System.Text.Json.JsonEncodedText.Encode("rule_type_counts");

	public override Elastic.Clients.Elasticsearch.QueryRules.QueryRulesetListItem Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<System.Collections.Generic.IReadOnlyDictionary<string, int>> propRuleCriteriaTypesCounts = default;
		LocalJsonValue<string> propRulesetId = default;
		LocalJsonValue<int> propRuleTotalCount = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyDictionary<string, int>> propRuleTypeCounts = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propRuleCriteriaTypesCounts.TryReadProperty(ref reader, options, PropRuleCriteriaTypesCounts, static System.Collections.Generic.IReadOnlyDictionary<string, int> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, int>(o, null, null)!))
			{
				continue;
			}

			if (propRulesetId.TryReadProperty(ref reader, options, PropRulesetId, null))
			{
				continue;
			}

			if (propRuleTotalCount.TryReadProperty(ref reader, options, PropRuleTotalCount, null))
			{
				continue;
			}

			if (propRuleTypeCounts.TryReadProperty(ref reader, options, PropRuleTypeCounts, static System.Collections.Generic.IReadOnlyDictionary<string, int> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, int>(o, null, null)!))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.QueryRules.QueryRulesetListItem(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			RuleCriteriaTypesCounts = propRuleCriteriaTypesCounts.Value,
			RulesetId = propRulesetId.Value,
			RuleTotalCount = propRuleTotalCount.Value,
			RuleTypeCounts = propRuleTypeCounts.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.QueryRules.QueryRulesetListItem value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropRuleCriteriaTypesCounts, value.RuleCriteriaTypesCounts, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyDictionary<string, int> v) => w.WriteDictionaryValue<string, int>(o, v, null, null));
		writer.WriteProperty(options, PropRulesetId, value.RulesetId, null, null);
		writer.WriteProperty(options, PropRuleTotalCount, value.RuleTotalCount, null, null);
		writer.WriteProperty(options, PropRuleTypeCounts, value.RuleTypeCounts, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyDictionary<string, int> v) => w.WriteDictionaryValue<string, int>(o, v, null, null));
		writer.WriteEndObject();
	}
}