// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryRules.Json;

public sealed partial class QueryRuleCriteriaTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAlways = System.Text.Json.JsonEncodedText.Encode("always");
	private static readonly System.Text.Json.JsonEncodedText MemberContains = System.Text.Json.JsonEncodedText.Encode("contains");
	private static readonly System.Text.Json.JsonEncodedText MemberExact = System.Text.Json.JsonEncodedText.Encode("exact");
	private static readonly System.Text.Json.JsonEncodedText MemberExactFuzzy = System.Text.Json.JsonEncodedText.Encode("exact_fuzzy");
	private static readonly System.Text.Json.JsonEncodedText MemberFuzzy = System.Text.Json.JsonEncodedText.Encode("fuzzy");
	private static readonly System.Text.Json.JsonEncodedText MemberGlobal = System.Text.Json.JsonEncodedText.Encode("global");
	private static readonly System.Text.Json.JsonEncodedText MemberGt = System.Text.Json.JsonEncodedText.Encode("gt");
	private static readonly System.Text.Json.JsonEncodedText MemberGte = System.Text.Json.JsonEncodedText.Encode("gte");
	private static readonly System.Text.Json.JsonEncodedText MemberLt = System.Text.Json.JsonEncodedText.Encode("lt");
	private static readonly System.Text.Json.JsonEncodedText MemberLte = System.Text.Json.JsonEncodedText.Encode("lte");
	private static readonly System.Text.Json.JsonEncodedText MemberPrefix = System.Text.Json.JsonEncodedText.Encode("prefix");
	private static readonly System.Text.Json.JsonEncodedText MemberSuffix = System.Text.Json.JsonEncodedText.Encode("suffix");

	public override Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAlways))
		{
			return Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Always;
		}

		if (reader.ValueTextEquals(MemberContains))
		{
			return Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Contains;
		}

		if (reader.ValueTextEquals(MemberExact))
		{
			return Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Exact;
		}

		if (reader.ValueTextEquals(MemberExactFuzzy))
		{
			return Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.ExactFuzzy;
		}

		if (reader.ValueTextEquals(MemberFuzzy))
		{
			return Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Fuzzy;
		}

		if (reader.ValueTextEquals(MemberGlobal))
		{
			return Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Global;
		}

		if (reader.ValueTextEquals(MemberGt))
		{
			return Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Gt;
		}

		if (reader.ValueTextEquals(MemberGte))
		{
			return Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Gte;
		}

		if (reader.ValueTextEquals(MemberLt))
		{
			return Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Lt;
		}

		if (reader.ValueTextEquals(MemberLte))
		{
			return Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Lte;
		}

		if (reader.ValueTextEquals(MemberPrefix))
		{
			return Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Prefix;
		}

		if (reader.ValueTextEquals(MemberSuffix))
		{
			return Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Suffix;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAlways.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Always;
		}

		if (string.Equals(value, MemberContains.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Contains;
		}

		if (string.Equals(value, MemberExact.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Exact;
		}

		if (string.Equals(value, MemberExactFuzzy.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.ExactFuzzy;
		}

		if (string.Equals(value, MemberFuzzy.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Fuzzy;
		}

		if (string.Equals(value, MemberGlobal.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Global;
		}

		if (string.Equals(value, MemberGt.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Gt;
		}

		if (string.Equals(value, MemberGte.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Gte;
		}

		if (string.Equals(value, MemberLt.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Lt;
		}

		if (string.Equals(value, MemberLte.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Lte;
		}

		if (string.Equals(value, MemberPrefix.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Prefix;
		}

		if (string.Equals(value, MemberSuffix.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Suffix;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Always:
				writer.WriteStringValue(MemberAlways);
				break;
			case Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Contains:
				writer.WriteStringValue(MemberContains);
				break;
			case Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Exact:
				writer.WriteStringValue(MemberExact);
				break;
			case Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.ExactFuzzy:
				writer.WriteStringValue(MemberExactFuzzy);
				break;
			case Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Fuzzy:
				writer.WriteStringValue(MemberFuzzy);
				break;
			case Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Global:
				writer.WriteStringValue(MemberGlobal);
				break;
			case Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Gt:
				writer.WriteStringValue(MemberGt);
				break;
			case Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Gte:
				writer.WriteStringValue(MemberGte);
				break;
			case Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Lt:
				writer.WriteStringValue(MemberLt);
				break;
			case Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Lte:
				writer.WriteStringValue(MemberLte);
				break;
			case Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Prefix:
				writer.WriteStringValue(MemberPrefix);
				break;
			case Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType.Suffix:
				writer.WriteStringValue(MemberSuffix);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}