// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryRules;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryRules.Json.QueryRuleCriteriaConverter))]
public sealed partial class QueryRuleCriteria
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public QueryRuleCriteria(Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType type)
	{
		Type = type;
	}
#if NET7_0_OR_GREATER
	public QueryRuleCriteria()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public QueryRuleCriteria()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal QueryRuleCriteria(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The metadata field to match against.
	/// This metadata will be used to match against <c>match_criteria</c> sent in the rule.
	/// It is required for all criteria types except <c>always</c>.
	/// </para>
	/// </summary>
	public string? Metadata { get; set; }

	/// <summary>
	/// <para>
	/// The type of criteria. The following criteria types are supported:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>always</c>: Matches all queries, regardless of input.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>contains</c>: Matches that contain this value anywhere in the field meet the criteria defined by the rule. Only applicable for string values.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>exact</c>: Only exact matches meet the criteria defined by the rule. Applicable for string or numerical values.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>fuzzy</c>: Exact matches or matches within the allowed Levenshtein Edit Distance meet the criteria defined by the rule. Only applicable for string values.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>gt</c>: Matches with a value greater than this value meet the criteria defined by the rule. Only applicable for numerical values.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>gte</c>: Matches with a value greater than or equal to this value meet the criteria defined by the rule. Only applicable for numerical values.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>lt</c>: Matches with a value less than this value meet the criteria defined by the rule. Only applicable for numerical values.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>lte</c>: Matches with a value less than or equal to this value meet the criteria defined by the rule. Only applicable for numerical values.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>prefix</c>: Matches that start with this value meet the criteria defined by the rule. Only applicable for string values.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>suffix</c>: Matches that end with this value meet the criteria defined by the rule. Only applicable for string values.
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType Type { get; set; }

	/// <summary>
	/// <para>
	/// The values to match against the <c>metadata</c> field.
	/// Only one value must match for the criteria to be met.
	/// It is required for all criteria types except <c>always</c>.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<object>? Values { get; set; }
}

public readonly partial struct QueryRuleCriteriaDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteria Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public QueryRuleCriteriaDescriptor(Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteria instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public QueryRuleCriteriaDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteria(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaDescriptor(Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteria instance) => new Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteria(Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The metadata field to match against.
	/// This metadata will be used to match against <c>match_criteria</c> sent in the rule.
	/// It is required for all criteria types except <c>always</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaDescriptor Metadata(string? value)
	{
		Instance.Metadata = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of criteria. The following criteria types are supported:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>always</c>: Matches all queries, regardless of input.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>contains</c>: Matches that contain this value anywhere in the field meet the criteria defined by the rule. Only applicable for string values.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>exact</c>: Only exact matches meet the criteria defined by the rule. Applicable for string or numerical values.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>fuzzy</c>: Exact matches or matches within the allowed Levenshtein Edit Distance meet the criteria defined by the rule. Only applicable for string values.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>gt</c>: Matches with a value greater than this value meet the criteria defined by the rule. Only applicable for numerical values.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>gte</c>: Matches with a value greater than or equal to this value meet the criteria defined by the rule. Only applicable for numerical values.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>lt</c>: Matches with a value less than this value meet the criteria defined by the rule. Only applicable for numerical values.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>lte</c>: Matches with a value less than or equal to this value meet the criteria defined by the rule. Only applicable for numerical values.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>prefix</c>: Matches that start with this value meet the criteria defined by the rule. Only applicable for string values.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>suffix</c>: Matches that end with this value meet the criteria defined by the rule. Only applicable for string values.
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaDescriptor Type(Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaType value)
	{
		Instance.Type = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The values to match against the <c>metadata</c> field.
	/// Only one value must match for the criteria to be met.
	/// It is required for all criteria types except <c>always</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaDescriptor Values(System.Collections.Generic.ICollection<object>? value)
	{
		Instance.Values = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The values to match against the <c>metadata</c> field.
	/// Only one value must match for the criteria to be met.
	/// It is required for all criteria types except <c>always</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaDescriptor Values(params object[] values)
	{
		Instance.Values = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteria Build(System.Action<Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaDescriptor(new Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteria(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}