// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryRules;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryRules.Json.QueryRuleConverter))]
public sealed partial class QueryRule
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public QueryRule(Elastic.Clients.Elasticsearch.QueryRules.QueryRuleActions actions, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteria> criteria, Elastic.Clients.Elasticsearch.Id ruleId, Elastic.Clients.Elasticsearch.QueryRules.QueryRuleType type)
	{
		Actions = actions;
		Criteria = criteria;
		RuleId = ruleId;
		Type = type;
	}
#if NET7_0_OR_GREATER
	public QueryRule()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public QueryRule()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal QueryRule(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The actions to take when the rule is matched.
	/// The format of this action depends on the rule type.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.QueryRules.QueryRuleActions Actions { get; set; }

	/// <summary>
	/// <para>
	/// The criteria that must be met for the rule to be applied.
	/// If multiple criteria are specified for a rule, all criteria must be met for the rule to be applied.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteria> Criteria { get; set; }
	public int? Priority { get; set; }

	/// <summary>
	/// <para>
	/// A unique identifier for the rule.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id RuleId { get; set; }

	/// <summary>
	/// <para>
	/// The type of rule.
	/// <c>pinned</c> will identify and pin specific documents to the top of search results.
	/// <c>exclude</c> will exclude specific documents from search results.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.QueryRules.QueryRuleType Type { get; set; }
}

public readonly partial struct QueryRuleDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryRules.QueryRule Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public QueryRuleDescriptor(Elastic.Clients.Elasticsearch.QueryRules.QueryRule instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public QueryRuleDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryRules.QueryRule(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryRules.QueryRuleDescriptor(Elastic.Clients.Elasticsearch.QueryRules.QueryRule instance) => new Elastic.Clients.Elasticsearch.QueryRules.QueryRuleDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryRules.QueryRule(Elastic.Clients.Elasticsearch.QueryRules.QueryRuleDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The actions to take when the rule is matched.
	/// The format of this action depends on the rule type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.QueryRuleDescriptor Actions(Elastic.Clients.Elasticsearch.QueryRules.QueryRuleActions value)
	{
		Instance.Actions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The actions to take when the rule is matched.
	/// The format of this action depends on the rule type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.QueryRuleDescriptor Actions()
	{
		Instance.Actions = Elastic.Clients.Elasticsearch.QueryRules.QueryRuleActionsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The actions to take when the rule is matched.
	/// The format of this action depends on the rule type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.QueryRuleDescriptor Actions(System.Action<Elastic.Clients.Elasticsearch.QueryRules.QueryRuleActionsDescriptor>? action)
	{
		Instance.Actions = Elastic.Clients.Elasticsearch.QueryRules.QueryRuleActionsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The criteria that must be met for the rule to be applied.
	/// If multiple criteria are specified for a rule, all criteria must be met for the rule to be applied.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.QueryRuleDescriptor Criteria(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteria> value)
	{
		Instance.Criteria = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The criteria that must be met for the rule to be applied.
	/// If multiple criteria are specified for a rule, all criteria must be met for the rule to be applied.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.QueryRuleDescriptor Criteria(params Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteria[] values)
	{
		Instance.Criteria = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The criteria that must be met for the rule to be applied.
	/// If multiple criteria are specified for a rule, all criteria must be met for the rule to be applied.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.QueryRuleDescriptor Criteria(params System.Action<Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteria>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaDescriptor.Build(action));
		}

		Instance.Criteria = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.QueryRuleDescriptor Priority(int? value)
	{
		Instance.Priority = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A unique identifier for the rule.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.QueryRuleDescriptor RuleId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.RuleId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of rule.
	/// <c>pinned</c> will identify and pin specific documents to the top of search results.
	/// <c>exclude</c> will exclude specific documents from search results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.QueryRuleDescriptor Type(Elastic.Clients.Elasticsearch.QueryRules.QueryRuleType value)
	{
		Instance.Type = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryRules.QueryRule Build(System.Action<Elastic.Clients.Elasticsearch.QueryRules.QueryRuleDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.QueryRuleDescriptor(new Elastic.Clients.Elasticsearch.QueryRules.QueryRule(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}