// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.WrapperQueryConverter))]
public sealed partial class WrapperQuery
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public WrapperQuery(string query)
	{
		Query = query;
	}
#if NET7_0_OR_GREATER
	public WrapperQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public WrapperQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal WrapperQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }

	/// <summary>
	/// <para>
	/// A base64 encoded query.
	/// The binary data format can be any of JSON, YAML, CBOR or SMILE encodings
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Query { get; set; }
	public string? QueryName { get; set; }
}

public readonly partial struct WrapperQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.WrapperQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public WrapperQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.WrapperQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public WrapperQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.WrapperQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.WrapperQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.WrapperQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.WrapperQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.WrapperQuery(Elastic.Clients.Elasticsearch.QueryDsl.WrapperQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.WrapperQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A base64 encoded query.
	/// The binary data format can be any of JSON, YAML, CBOR or SMILE encodings
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.WrapperQueryDescriptor Query(string value)
	{
		Instance.Query = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.WrapperQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.WrapperQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.WrapperQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.WrapperQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.WrapperQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}