// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.WeightedTokensQueryConverter))]
public sealed partial class WeightedTokensQuery
{
	[System.Obsolete("The type contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public WeightedTokensQuery(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public WeightedTokensQuery(Elastic.Clients.Elasticsearch.Field field, System.Collections.Generic.ICollection<System.Collections.Generic.IDictionary<string, float>> tokens)
	{
		Field = field;
		Tokens = tokens;
	}
#if NET7_0_OR_GREATER
	public WeightedTokensQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal WeightedTokensQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Token pruning configurations
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TokenPruningConfig? PruningConfig { get; set; }
	public string? QueryName { get; set; }

	/// <summary>
	/// <para>
	/// The tokens representing this query
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<System.Collections.Generic.IDictionary<string, float>> Tokens { get; set; }
}

public readonly partial struct WeightedTokensQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public WeightedTokensQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public WeightedTokensQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQuery(Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Token pruning configurations
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor<TDocument> PruningConfig(Elastic.Clients.Elasticsearch.TokenPruningConfig? value)
	{
		Instance.PruningConfig = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Token pruning configurations
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor<TDocument> PruningConfig()
	{
		Instance.PruningConfig = Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Token pruning configurations
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor<TDocument> PruningConfig(System.Action<Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor>? action)
	{
		Instance.PruningConfig = Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The tokens representing this query
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor<TDocument> Tokens(System.Collections.Generic.ICollection<System.Collections.Generic.IDictionary<string, float>> value)
	{
		Instance.Tokens = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The tokens representing this query
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor<TDocument> Tokens(params System.Collections.Generic.IDictionary<string, float>[] values)
	{
		Instance.Tokens = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The tokens representing this query
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor<TDocument> Tokens(params System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringFloat>?[] actions)
	{
		var items = new System.Collections.Generic.List<System.Collections.Generic.IDictionary<string, float>>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringFloat.Build(action));
		}

		Instance.Tokens = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct WeightedTokensQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public WeightedTokensQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public WeightedTokensQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQuery(Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Token pruning configurations
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor PruningConfig(Elastic.Clients.Elasticsearch.TokenPruningConfig? value)
	{
		Instance.PruningConfig = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Token pruning configurations
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor PruningConfig()
	{
		Instance.PruningConfig = Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Token pruning configurations
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor PruningConfig(System.Action<Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor>? action)
	{
		Instance.PruningConfig = Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The tokens representing this query
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor Tokens(System.Collections.Generic.ICollection<System.Collections.Generic.IDictionary<string, float>> value)
	{
		Instance.Tokens = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The tokens representing this query
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor Tokens(params System.Collections.Generic.IDictionary<string, float>[] values)
	{
		Instance.Tokens = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The tokens representing this query
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor Tokens(params System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringFloat>?[] actions)
	{
		var items = new System.Collections.Generic.List<System.Collections.Generic.IDictionary<string, float>>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringFloat.Build(action));
		}

		Instance.Tokens = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}