// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.UntypedRangeQueryConverter))]
public sealed partial class UntypedRangeQuery : Elastic.Clients.Elasticsearch.QueryDsl.IRangeQuery
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UntypedRangeQuery(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}
#if NET7_0_OR_GREATER
	public UntypedRangeQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal UntypedRangeQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Date format used to convert <c>date</c> values in the query.
	/// </para>
	/// </summary>
	public string? Format { get; set; }

	/// <summary>
	/// <para>
	/// Greater than.
	/// </para>
	/// </summary>
	public object? Gt { get; set; }

	/// <summary>
	/// <para>
	/// Greater than or equal to.
	/// </para>
	/// </summary>
	public object? Gte { get; set; }

	/// <summary>
	/// <para>
	/// Less than.
	/// </para>
	/// </summary>
	public object? Lt { get; set; }

	/// <summary>
	/// <para>
	/// Less than or equal to.
	/// </para>
	/// </summary>
	public object? Lte { get; set; }
	public string? QueryName { get; set; }

	/// <summary>
	/// <para>
	/// Indicates how the range query matches values for <c>range</c> fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation? Relation { get; set; }

	/// <summary>
	/// <para>
	/// Coordinated Universal Time (UTC) offset or IANA time zone used to convert <c>date</c> values in the query to UTC.
	/// </para>
	/// </summary>
	public string? TimeZone { get; set; }

	string Elastic.Clients.Elasticsearch.QueryDsl.IRangeQuery.Type => "untyped";
}

public readonly partial struct UntypedRangeQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UntypedRangeQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UntypedRangeQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQuery(Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Date format used to convert <c>date</c> values in the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor<TDocument> Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Greater than.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor<TDocument> Gt(object? value)
	{
		Instance.Gt = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Greater than or equal to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor<TDocument> Gte(object? value)
	{
		Instance.Gte = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Less than.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor<TDocument> Lt(object? value)
	{
		Instance.Lt = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Less than or equal to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor<TDocument> Lte(object? value)
	{
		Instance.Lte = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates how the range query matches values for <c>range</c> fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor<TDocument> Relation(Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation? value)
	{
		Instance.Relation = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Coordinated Universal Time (UTC) offset or IANA time zone used to convert <c>date</c> values in the query to UTC.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor<TDocument> TimeZone(string? value)
	{
		Instance.TimeZone = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct UntypedRangeQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UntypedRangeQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UntypedRangeQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQuery(Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Date format used to convert <c>date</c> values in the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Greater than.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor Gt(object? value)
	{
		Instance.Gt = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Greater than or equal to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor Gte(object? value)
	{
		Instance.Gte = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Less than.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor Lt(object? value)
	{
		Instance.Lt = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Less than or equal to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor Lte(object? value)
	{
		Instance.Lte = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates how the range query matches values for <c>range</c> fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor Relation(Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation? value)
	{
		Instance.Relation = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Coordinated Universal Time (UTC) offset or IANA time zone used to convert <c>date</c> values in the query to UTC.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor TimeZone(string? value)
	{
		Instance.TimeZone = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}