// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.UntypedDistanceFeatureQueryConverter))]
public sealed partial class UntypedDistanceFeatureQuery : Elastic.Clients.Elasticsearch.QueryDsl.IDistanceFeatureQuery
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UntypedDistanceFeatureQuery(Elastic.Clients.Elasticsearch.Field field, object origin, object pivot)
	{
		Field = field;
		Origin = origin;
		Pivot = pivot;
	}
#if NET7_0_OR_GREATER
	public UntypedDistanceFeatureQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public UntypedDistanceFeatureQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal UntypedDistanceFeatureQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }

	/// <summary>
	/// <para>
	/// Name of the field used to calculate distances. This field must meet the following criteria:
	/// be a <c>date</c>, <c>date_nanos</c> or <c>geo_point</c> field;
	/// have an <c>index</c> mapping parameter value of <c>true</c>, which is the default;
	/// have an <c>doc_values</c> mapping parameter value of <c>true</c>, which is the default.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Date or point of origin used to calculate distances.
	/// If the <c>field</c> value is a <c>date</c> or <c>date_nanos</c> field, the <c>origin</c> value must be a date.
	/// Date Math, such as <c>now-1h</c>, is supported.
	/// If the field value is a <c>geo_point</c> field, the <c>origin</c> value must be a geopoint.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	object Origin { get; set; }

	/// <summary>
	/// <para>
	/// Distance from the <c>origin</c> at which relevance scores receive half of the <c>boost</c> value.
	/// If the <c>field</c> value is a <c>date</c> or <c>date_nanos</c> field, the <c>pivot</c> value must be a time unit, such as <c>1h</c> or <c>10d</c>. If the <c>field</c> value is a <c>geo_point</c> field, the <c>pivot</c> value must be a distance unit, such as <c>1km</c> or <c>12m</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	object Pivot { get; set; }
	public string? QueryName { get; set; }

	string Elastic.Clients.Elasticsearch.QueryDsl.IDistanceFeatureQuery.Type => "untyped";
}

public readonly partial struct UntypedDistanceFeatureQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UntypedDistanceFeatureQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UntypedDistanceFeatureQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQuery(Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Name of the field used to calculate distances. This field must meet the following criteria:
	/// be a <c>date</c>, <c>date_nanos</c> or <c>geo_point</c> field;
	/// have an <c>index</c> mapping parameter value of <c>true</c>, which is the default;
	/// have an <c>doc_values</c> mapping parameter value of <c>true</c>, which is the default.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQueryDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Name of the field used to calculate distances. This field must meet the following criteria:
	/// be a <c>date</c>, <c>date_nanos</c> or <c>geo_point</c> field;
	/// have an <c>index</c> mapping parameter value of <c>true</c>, which is the default;
	/// have an <c>doc_values</c> mapping parameter value of <c>true</c>, which is the default.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQueryDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Date or point of origin used to calculate distances.
	/// If the <c>field</c> value is a <c>date</c> or <c>date_nanos</c> field, the <c>origin</c> value must be a date.
	/// Date Math, such as <c>now-1h</c>, is supported.
	/// If the field value is a <c>geo_point</c> field, the <c>origin</c> value must be a geopoint.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQueryDescriptor<TDocument> Origin(object value)
	{
		Instance.Origin = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Distance from the <c>origin</c> at which relevance scores receive half of the <c>boost</c> value.
	/// If the <c>field</c> value is a <c>date</c> or <c>date_nanos</c> field, the <c>pivot</c> value must be a time unit, such as <c>1h</c> or <c>10d</c>. If the <c>field</c> value is a <c>geo_point</c> field, the <c>pivot</c> value must be a distance unit, such as <c>1km</c> or <c>12m</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQueryDescriptor<TDocument> Pivot(object value)
	{
		Instance.Pivot = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct UntypedDistanceFeatureQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UntypedDistanceFeatureQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UntypedDistanceFeatureQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQuery(Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Name of the field used to calculate distances. This field must meet the following criteria:
	/// be a <c>date</c>, <c>date_nanos</c> or <c>geo_point</c> field;
	/// have an <c>index</c> mapping parameter value of <c>true</c>, which is the default;
	/// have an <c>doc_values</c> mapping parameter value of <c>true</c>, which is the default.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQueryDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Name of the field used to calculate distances. This field must meet the following criteria:
	/// be a <c>date</c>, <c>date_nanos</c> or <c>geo_point</c> field;
	/// have an <c>index</c> mapping parameter value of <c>true</c>, which is the default;
	/// have an <c>doc_values</c> mapping parameter value of <c>true</c>, which is the default.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQueryDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Date or point of origin used to calculate distances.
	/// If the <c>field</c> value is a <c>date</c> or <c>date_nanos</c> field, the <c>origin</c> value must be a date.
	/// Date Math, such as <c>now-1h</c>, is supported.
	/// If the field value is a <c>geo_point</c> field, the <c>origin</c> value must be a geopoint.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQueryDescriptor Origin(object value)
	{
		Instance.Origin = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Distance from the <c>origin</c> at which relevance scores receive half of the <c>boost</c> value.
	/// If the <c>field</c> value is a <c>date</c> or <c>date_nanos</c> field, the <c>pivot</c> value must be a time unit, such as <c>1h</c> or <c>10d</c>. If the <c>field</c> value is a <c>geo_point</c> field, the <c>pivot</c> value must be a distance unit, such as <c>1km</c> or <c>12m</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQueryDescriptor Pivot(object value)
	{
		Instance.Pivot = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.UntypedDistanceFeatureQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}