// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.TextQueryTypeConverter))]
public enum TextQueryType
{
	/// <summary>
	/// <para>
	/// Finds documents that match any field, but uses the <c>_score</c> from the best field.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "best_fields")]
	BestFields,
	/// <summary>
	/// <para>
	/// Creates a <c>match_bool_prefix</c> query on each field and combines the <c>_score</c> from each field.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "bool_prefix")]
	BoolPrefix,
	/// <summary>
	/// <para>
	/// Treats fields with the same analyzer as though they were one big field.
	/// Looks for each word in any field.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "cross_fields")]
	CrossFields,
	/// <summary>
	/// <para>
	/// Finds documents that match any field and combines the <c>_score</c> from each field.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "most_fields")]
	MostFields,
	/// <summary>
	/// <para>
	/// Runs a <c>match_phrase</c> query on each field and uses the <c>_score</c> from the best field.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "phrase")]
	Phrase,
	/// <summary>
	/// <para>
	/// Runs a <c>match_phrase_prefix</c> query on each field and uses the <c>_score</c> from the best field.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "phrase_prefix")]
	PhrasePrefix
}