// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl.Json;

public sealed partial class TextQueryTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberBestFields = System.Text.Json.JsonEncodedText.Encode("best_fields");
	private static readonly System.Text.Json.JsonEncodedText MemberBoolPrefix = System.Text.Json.JsonEncodedText.Encode("bool_prefix");
	private static readonly System.Text.Json.JsonEncodedText MemberCrossFields = System.Text.Json.JsonEncodedText.Encode("cross_fields");
	private static readonly System.Text.Json.JsonEncodedText MemberMostFields = System.Text.Json.JsonEncodedText.Encode("most_fields");
	private static readonly System.Text.Json.JsonEncodedText MemberPhrase = System.Text.Json.JsonEncodedText.Encode("phrase");
	private static readonly System.Text.Json.JsonEncodedText MemberPhrasePrefix = System.Text.Json.JsonEncodedText.Encode("phrase_prefix");

	public override Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberBestFields))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType.BestFields;
		}

		if (reader.ValueTextEquals(MemberBoolPrefix))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType.BoolPrefix;
		}

		if (reader.ValueTextEquals(MemberCrossFields))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType.CrossFields;
		}

		if (reader.ValueTextEquals(MemberMostFields))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType.MostFields;
		}

		if (reader.ValueTextEquals(MemberPhrase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType.Phrase;
		}

		if (reader.ValueTextEquals(MemberPhrasePrefix))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType.PhrasePrefix;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberBestFields.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType.BestFields;
		}

		if (string.Equals(value, MemberBoolPrefix.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType.BoolPrefix;
		}

		if (string.Equals(value, MemberCrossFields.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType.CrossFields;
		}

		if (string.Equals(value, MemberMostFields.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType.MostFields;
		}

		if (string.Equals(value, MemberPhrase.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType.Phrase;
		}

		if (string.Equals(value, MemberPhrasePrefix.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType.PhrasePrefix;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType.BestFields:
				writer.WriteStringValue(MemberBestFields);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType.BoolPrefix:
				writer.WriteStringValue(MemberBoolPrefix);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType.CrossFields:
				writer.WriteStringValue(MemberCrossFields);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType.MostFields:
				writer.WriteStringValue(MemberMostFields);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType.Phrase:
				writer.WriteStringValue(MemberPhrase);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType.PhrasePrefix:
				writer.WriteStringValue(MemberPhrasePrefix);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}