// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.TextExpansionQueryConverter))]
public sealed partial class TextExpansionQuery
{
	[System.Obsolete("The type contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public TextExpansionQuery(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TextExpansionQuery(Elastic.Clients.Elasticsearch.Field field, string modelId, string modelText)
	{
		Field = field;
		ModelId = modelId;
		ModelText = modelText;
	}
#if NET7_0_OR_GREATER
	public TextExpansionQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TextExpansionQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// The text expansion NLP model to use
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ModelId { get; set; }

	/// <summary>
	/// <para>
	/// The query text
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ModelText { get; set; }

	/// <summary>
	/// <para>
	/// Token pruning configurations
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TokenPruningConfig? PruningConfig { get; set; }
	public string? QueryName { get; set; }
}

public readonly partial struct TextExpansionQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TextExpansionQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TextExpansionQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQuery(Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The text expansion NLP model to use
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor<TDocument> ModelId(string value)
	{
		Instance.ModelId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The query text
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor<TDocument> ModelText(string value)
	{
		Instance.ModelText = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Token pruning configurations
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor<TDocument> PruningConfig(Elastic.Clients.Elasticsearch.TokenPruningConfig? value)
	{
		Instance.PruningConfig = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Token pruning configurations
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor<TDocument> PruningConfig()
	{
		Instance.PruningConfig = Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Token pruning configurations
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor<TDocument> PruningConfig(System.Action<Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor>? action)
	{
		Instance.PruningConfig = Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct TextExpansionQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TextExpansionQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TextExpansionQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQuery(Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The text expansion NLP model to use
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor ModelId(string value)
	{
		Instance.ModelId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The query text
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor ModelText(string value)
	{
		Instance.ModelText = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Token pruning configurations
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor PruningConfig(Elastic.Clients.Elasticsearch.TokenPruningConfig? value)
	{
		Instance.PruningConfig = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Token pruning configurations
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor PruningConfig()
	{
		Instance.PruningConfig = Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Token pruning configurations
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor PruningConfig(System.Action<Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor>? action)
	{
		Instance.PruningConfig = Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}