// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.TermsQueryConverter))]
public sealed partial class TermsQuery
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TermsQuery(Elastic.Clients.Elasticsearch.Field field, Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryField terms)
	{
		Field = field;
		Terms = terms;
	}
#if NET7_0_OR_GREATER
	public TermsQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public TermsQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TermsQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }
	public string? QueryName { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryField Terms { get; set; }
}

public readonly partial struct TermsQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.TermsQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TermsQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.TermsQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TermsQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.TermsQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.TermsQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.TermsQuery(Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor<TDocument> Terms(Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryField value)
	{
		Instance.Terms = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor<TDocument> Terms(System.Func<Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryFieldFactory<TDocument>, Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryField> action)
	{
		Instance.Terms = Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryFieldFactory<TDocument>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.TermsQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.TermsQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct TermsQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.TermsQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TermsQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.TermsQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TermsQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.TermsQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.TermsQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.TermsQuery(Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor Terms(Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryField value)
	{
		Instance.Terms = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor Terms(System.Func<Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryFieldFactory, Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryField> action)
	{
		Instance.Terms = Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryFieldFactory.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor Terms<T>(System.Func<Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryFieldFactory<T>, Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryField> action)
	{
		Instance.Terms = Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryFieldFactory<T>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.TermsQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.TermsQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}