// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.TermRangeQueryConverter))]
public sealed partial class TermRangeQuery : Elastic.Clients.Elasticsearch.QueryDsl.IRangeQuery
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TermRangeQuery(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}
#if NET7_0_OR_GREATER
	public TermRangeQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TermRangeQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Greater than.
	/// </para>
	/// </summary>
	public string? Gt { get; set; }

	/// <summary>
	/// <para>
	/// Greater than or equal to.
	/// </para>
	/// </summary>
	public string? Gte { get; set; }

	/// <summary>
	/// <para>
	/// Less than.
	/// </para>
	/// </summary>
	public string? Lt { get; set; }

	/// <summary>
	/// <para>
	/// Less than or equal to.
	/// </para>
	/// </summary>
	public string? Lte { get; set; }
	public string? QueryName { get; set; }

	/// <summary>
	/// <para>
	/// Indicates how the range query matches values for <c>range</c> fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation? Relation { get; set; }

	string Elastic.Clients.Elasticsearch.QueryDsl.IRangeQuery.Type => "term";
}

public readonly partial struct TermRangeQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TermRangeQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TermRangeQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQuery(Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Greater than.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor<TDocument> Gt(string? value)
	{
		Instance.Gt = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Greater than or equal to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor<TDocument> Gte(string? value)
	{
		Instance.Gte = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Less than.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor<TDocument> Lt(string? value)
	{
		Instance.Lt = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Less than or equal to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor<TDocument> Lte(string? value)
	{
		Instance.Lte = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates how the range query matches values for <c>range</c> fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor<TDocument> Relation(Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation? value)
	{
		Instance.Relation = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct TermRangeQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TermRangeQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TermRangeQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQuery(Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Greater than.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor Gt(string? value)
	{
		Instance.Gt = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Greater than or equal to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor Gte(string? value)
	{
		Instance.Gte = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Less than.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor Lt(string? value)
	{
		Instance.Lt = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Less than or equal to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor Lte(string? value)
	{
		Instance.Lte = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates how the range query matches values for <c>range</c> fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor Relation(Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation? value)
	{
		Instance.Relation = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}