// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.SparseVectorQueryConverter))]
public sealed partial class SparseVectorQuery
{
	internal string? VariantType { get; set; }
	internal object? Variant { get; set; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SparseVectorQuery(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}
#if NET7_0_OR_GREATER
	public SparseVectorQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public SparseVectorQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SparseVectorQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The inference ID to use to convert the query text into token-weight pairs.
	/// It must be the same inference ID that was used to create the tokens from the input text.
	/// Only one of inference_id and query_vector is allowed.
	/// If inference_id is specified, query must also be specified.
	/// Only one of inference_id or query_vector may be supplied in a request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Id? InferenceId { get => GetVariant<Elastic.Clients.Elasticsearch.Id>("inference_id"); set => SetVariant("inference_id", value); }

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }

	/// <summary>
	/// <para>
	/// The name of the field that contains the token-weight pairs to be searched against.
	/// This field must be a mapped sparse_vector field.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Whether to perform pruning, omitting the non-significant tokens from the query to improve query performance.
	/// If prune is true but the pruning_config is not specified, pruning will occur but default values will be used.
	/// Default: false
	/// </para>
	/// </summary>
	public bool? Prune { get; set; }

	/// <summary>
	/// <para>
	/// Optional pruning configuration.
	/// If enabled, this will omit non-significant tokens from the query in order to improve query performance.
	/// This is only used if prune is set to true.
	/// If prune is set to true but pruning_config is not specified, default values will be used.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TokenPruningConfig? PruningConfig { get; set; }

	/// <summary>
	/// <para>
	/// The query text you want to use for search.
	/// If inference_id is specified, query must also be specified.
	/// </para>
	/// </summary>
	public string? Query { get; set; }
	public string? QueryName { get; set; }

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private T? GetVariant<T>(string type)
	{
		if (string.Equals(VariantType, type, System.StringComparison.Ordinal) && Variant is T result)
		{
			return result;
		}

		return default;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private void SetVariant<T>(string type, T? value)
	{
		VariantType = type;
		Variant = value;
	}
}

public readonly partial struct SparseVectorQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SparseVectorQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SparseVectorQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQuery(Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The inference ID to use to convert the query text into token-weight pairs.
	/// It must be the same inference ID that was used to create the tokens from the input text.
	/// Only one of inference_id and query_vector is allowed.
	/// If inference_id is specified, query must also be specified.
	/// Only one of inference_id or query_vector may be supplied in a request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor<TDocument> InferenceId(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.InferenceId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the field that contains the token-weight pairs to be searched against.
	/// This field must be a mapped sparse_vector field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the field that contains the token-weight pairs to be searched against.
	/// This field must be a mapped sparse_vector field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether to perform pruning, omitting the non-significant tokens from the query to improve query performance.
	/// If prune is true but the pruning_config is not specified, pruning will occur but default values will be used.
	/// Default: false
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor<TDocument> Prune(bool? value = true)
	{
		Instance.Prune = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional pruning configuration.
	/// If enabled, this will omit non-significant tokens from the query in order to improve query performance.
	/// This is only used if prune is set to true.
	/// If prune is set to true but pruning_config is not specified, default values will be used.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor<TDocument> PruningConfig(Elastic.Clients.Elasticsearch.TokenPruningConfig? value)
	{
		Instance.PruningConfig = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional pruning configuration.
	/// If enabled, this will omit non-significant tokens from the query in order to improve query performance.
	/// This is only used if prune is set to true.
	/// If prune is set to true but pruning_config is not specified, default values will be used.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor<TDocument> PruningConfig()
	{
		Instance.PruningConfig = Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional pruning configuration.
	/// If enabled, this will omit non-significant tokens from the query in order to improve query performance.
	/// This is only used if prune is set to true.
	/// If prune is set to true but pruning_config is not specified, default values will be used.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor<TDocument> PruningConfig(System.Action<Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor>? action)
	{
		Instance.PruningConfig = Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The query text you want to use for search.
	/// If inference_id is specified, query must also be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor<TDocument> Query(string? value)
	{
		Instance.Query = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct SparseVectorQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SparseVectorQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SparseVectorQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQuery(Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The inference ID to use to convert the query text into token-weight pairs.
	/// It must be the same inference ID that was used to create the tokens from the input text.
	/// Only one of inference_id and query_vector is allowed.
	/// If inference_id is specified, query must also be specified.
	/// Only one of inference_id or query_vector may be supplied in a request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor InferenceId(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.InferenceId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the field that contains the token-weight pairs to be searched against.
	/// This field must be a mapped sparse_vector field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the field that contains the token-weight pairs to be searched against.
	/// This field must be a mapped sparse_vector field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether to perform pruning, omitting the non-significant tokens from the query to improve query performance.
	/// If prune is true but the pruning_config is not specified, pruning will occur but default values will be used.
	/// Default: false
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor Prune(bool? value = true)
	{
		Instance.Prune = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional pruning configuration.
	/// If enabled, this will omit non-significant tokens from the query in order to improve query performance.
	/// This is only used if prune is set to true.
	/// If prune is set to true but pruning_config is not specified, default values will be used.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor PruningConfig(Elastic.Clients.Elasticsearch.TokenPruningConfig? value)
	{
		Instance.PruningConfig = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional pruning configuration.
	/// If enabled, this will omit non-significant tokens from the query in order to improve query performance.
	/// This is only used if prune is set to true.
	/// If prune is set to true but pruning_config is not specified, default values will be used.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor PruningConfig()
	{
		Instance.PruningConfig = Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional pruning configuration.
	/// If enabled, this will omit non-significant tokens from the query in order to improve query performance.
	/// This is only used if prune is set to true.
	/// If prune is set to true but pruning_config is not specified, default values will be used.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor PruningConfig(System.Action<Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor>? action)
	{
		Instance.PruningConfig = Elastic.Clients.Elasticsearch.TokenPruningConfigDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The query text you want to use for search.
	/// If inference_id is specified, query must also be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor Query(string? value)
	{
		Instance.Query = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}