// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.SpanWithinQueryConverter))]
public sealed partial class SpanWithinQuery
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SpanWithinQuery(Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery big, Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery little)
	{
		Big = big;
		Little = little;
	}
#if NET7_0_OR_GREATER
	public SpanWithinQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public SpanWithinQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SpanWithinQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Can be any span query.
	/// Matching spans from <c>little</c> that are enclosed within <c>big</c> are returned.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery Big { get; set; }

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }

	/// <summary>
	/// <para>
	/// Can be any span query.
	/// Matching spans from <c>little</c> that are enclosed within <c>big</c> are returned.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery Little { get; set; }
	public string? QueryName { get; set; }
}

public readonly partial struct SpanWithinQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SpanWithinQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SpanWithinQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQuery(Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Can be any span query.
	/// Matching spans from <c>little</c> that are enclosed within <c>big</c> are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQueryDescriptor<TDocument> Big(Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery value)
	{
		Instance.Big = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be any span query.
	/// Matching spans from <c>little</c> that are enclosed within <c>big</c> are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQueryDescriptor<TDocument> Big(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor<TDocument>> action)
	{
		Instance.Big = Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be any span query.
	/// Matching spans from <c>little</c> that are enclosed within <c>big</c> are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQueryDescriptor<TDocument> Little(Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery value)
	{
		Instance.Little = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be any span query.
	/// Matching spans from <c>little</c> that are enclosed within <c>big</c> are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQueryDescriptor<TDocument> Little(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor<TDocument>> action)
	{
		Instance.Little = Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct SpanWithinQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SpanWithinQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SpanWithinQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQuery(Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Can be any span query.
	/// Matching spans from <c>little</c> that are enclosed within <c>big</c> are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQueryDescriptor Big(Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery value)
	{
		Instance.Big = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be any span query.
	/// Matching spans from <c>little</c> that are enclosed within <c>big</c> are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQueryDescriptor Big(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor> action)
	{
		Instance.Big = Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be any span query.
	/// Matching spans from <c>little</c> that are enclosed within <c>big</c> are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQueryDescriptor Big<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor<T>> action)
	{
		Instance.Big = Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be any span query.
	/// Matching spans from <c>little</c> that are enclosed within <c>big</c> are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQueryDescriptor Little(Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery value)
	{
		Instance.Little = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be any span query.
	/// Matching spans from <c>little</c> that are enclosed within <c>big</c> are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQueryDescriptor Little(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor> action)
	{
		Instance.Little = Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be any span query.
	/// Matching spans from <c>little</c> that are enclosed within <c>big</c> are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQueryDescriptor Little<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor<T>> action)
	{
		Instance.Little = Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}