// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl.Json;

public sealed partial class SpanQueryConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery>
{
	private static readonly System.Text.Json.JsonEncodedText VariantSpanContaining = System.Text.Json.JsonEncodedText.Encode("span_containing");
	private static readonly System.Text.Json.JsonEncodedText VariantSpanFieldMasking = System.Text.Json.JsonEncodedText.Encode("span_field_masking");
	private static readonly System.Text.Json.JsonEncodedText VariantSpanFirst = System.Text.Json.JsonEncodedText.Encode("span_first");
	private static readonly System.Text.Json.JsonEncodedText VariantSpanGap = System.Text.Json.JsonEncodedText.Encode("span_gap");
	private static readonly System.Text.Json.JsonEncodedText VariantSpanMulti = System.Text.Json.JsonEncodedText.Encode("span_multi");
	private static readonly System.Text.Json.JsonEncodedText VariantSpanNear = System.Text.Json.JsonEncodedText.Encode("span_near");
	private static readonly System.Text.Json.JsonEncodedText VariantSpanNot = System.Text.Json.JsonEncodedText.Encode("span_not");
	private static readonly System.Text.Json.JsonEncodedText VariantSpanOr = System.Text.Json.JsonEncodedText.Encode("span_or");
	private static readonly System.Text.Json.JsonEncodedText VariantSpanTerm = System.Text.Json.JsonEncodedText.Encode("span_term");
	private static readonly System.Text.Json.JsonEncodedText VariantSpanWithin = System.Text.Json.JsonEncodedText.Encode("span_within");

	public override Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		string? variantType = null;
		object? variant = null;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (reader.ValueTextEquals(VariantSpanContaining))
			{
				variantType = VariantSpanContaining.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSpanFieldMasking))
			{
				variantType = VariantSpanFieldMasking.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.SpanFieldMaskingQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSpanFirst))
			{
				variantType = VariantSpanFirst.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.SpanFirstQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSpanGap))
			{
				variantType = VariantSpanGap.Value;
				reader.Read();
				variant = reader.ReadValue<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, int>>(options, static System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, int> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadKeyValuePairValue<Elastic.Clients.Elasticsearch.Field, int>(o, null, null));
				continue;
			}

			if (reader.ValueTextEquals(VariantSpanMulti))
			{
				variantType = VariantSpanMulti.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.SpanMultiTermQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSpanNear))
			{
				variantType = VariantSpanNear.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.SpanNearQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSpanNot))
			{
				variantType = VariantSpanNot.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSpanOr))
			{
				variantType = VariantSpanOr.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.SpanOrQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSpanTerm))
			{
				variantType = VariantSpanTerm.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.SpanTermQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSpanWithin))
			{
				variantType = VariantSpanWithin.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQuery>(options, null);
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			VariantType = variantType,
			Variant = variant
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		switch (value.VariantType)
		{
			case null:
				break;
			case "span_containing":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQuery)value.Variant, null, null);
				break;
			case "span_field_masking":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.SpanFieldMaskingQuery)value.Variant, null, null);
				break;
			case "span_first":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.SpanFirstQuery)value.Variant, null, null);
				break;
			case "span_gap":
				writer.WriteProperty(options, value.VariantType, (System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, int>)value.Variant, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, int> v) => w.WriteKeyValuePairValue<Elastic.Clients.Elasticsearch.Field, int>(o, v, null, null));
				break;
			case "span_multi":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.SpanMultiTermQuery)value.Variant, null, null);
				break;
			case "span_near":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.SpanNearQuery)value.Variant, null, null);
				break;
			case "span_not":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQuery)value.Variant, null, null);
				break;
			case "span_or":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.SpanOrQuery)value.Variant, null, null);
				break;
			case "span_term":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.SpanTermQuery)value.Variant, null, null);
				break;
			case "span_within":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQuery)value.Variant, null, null);
				break;
			default:
				throw new System.Text.Json.JsonException($"Variant '{value.VariantType}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery)}'.");
		}

		writer.WriteEndObject();
	}
}