// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.SpanNotQueryConverter))]
public sealed partial class SpanNotQuery
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SpanNotQuery(Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery exclude, Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery include)
	{
		Exclude = exclude;
		Include = include;
	}
#if NET7_0_OR_GREATER
	public SpanNotQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public SpanNotQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SpanNotQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }

	/// <summary>
	/// <para>
	/// The number of tokens from within the include span that can’t have overlap with the exclude span.
	/// Equivalent to setting both <c>pre</c> and <c>post</c>.
	/// </para>
	/// </summary>
	public int? Dist { get; set; }

	/// <summary>
	/// <para>
	/// Span query whose matches must not overlap those returned.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery Exclude { get; set; }

	/// <summary>
	/// <para>
	/// Span query whose matches are filtered.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery Include { get; set; }

	/// <summary>
	/// <para>
	/// The number of tokens after the include span that can’t have overlap with the exclude span.
	/// </para>
	/// </summary>
	public int? Post { get; set; }

	/// <summary>
	/// <para>
	/// The number of tokens before the include span that can’t have overlap with the exclude span.
	/// </para>
	/// </summary>
	public int? Pre { get; set; }
	public string? QueryName { get; set; }
}

public readonly partial struct SpanNotQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SpanNotQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SpanNotQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQuery(Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of tokens from within the include span that can’t have overlap with the exclude span.
	/// Equivalent to setting both <c>pre</c> and <c>post</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor<TDocument> Dist(int? value)
	{
		Instance.Dist = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Span query whose matches must not overlap those returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor<TDocument> Exclude(Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery value)
	{
		Instance.Exclude = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Span query whose matches must not overlap those returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor<TDocument> Exclude(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor<TDocument>> action)
	{
		Instance.Exclude = Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Span query whose matches are filtered.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor<TDocument> Include(Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery value)
	{
		Instance.Include = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Span query whose matches are filtered.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor<TDocument> Include(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor<TDocument>> action)
	{
		Instance.Include = Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of tokens after the include span that can’t have overlap with the exclude span.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor<TDocument> Post(int? value)
	{
		Instance.Post = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of tokens before the include span that can’t have overlap with the exclude span.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor<TDocument> Pre(int? value)
	{
		Instance.Pre = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct SpanNotQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SpanNotQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SpanNotQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQuery(Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of tokens from within the include span that can’t have overlap with the exclude span.
	/// Equivalent to setting both <c>pre</c> and <c>post</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor Dist(int? value)
	{
		Instance.Dist = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Span query whose matches must not overlap those returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor Exclude(Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery value)
	{
		Instance.Exclude = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Span query whose matches must not overlap those returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor Exclude(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor> action)
	{
		Instance.Exclude = Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Span query whose matches must not overlap those returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor Exclude<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor<T>> action)
	{
		Instance.Exclude = Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Span query whose matches are filtered.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor Include(Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery value)
	{
		Instance.Include = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Span query whose matches are filtered.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor Include(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor> action)
	{
		Instance.Include = Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Span query whose matches are filtered.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor Include<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor<T>> action)
	{
		Instance.Include = Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of tokens after the include span that can’t have overlap with the exclude span.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor Post(int? value)
	{
		Instance.Post = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of tokens before the include span that can’t have overlap with the exclude span.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor Pre(int? value)
	{
		Instance.Pre = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}