// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.SpanContainingQueryConverter))]
public sealed partial class SpanContainingQuery
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SpanContainingQuery(Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery big, Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery little)
	{
		Big = big;
		Little = little;
	}
#if NET7_0_OR_GREATER
	public SpanContainingQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public SpanContainingQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SpanContainingQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Can be any span query.
	/// Matching spans from <c>big</c> that contain matches from <c>little</c> are returned.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery Big { get; set; }

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }

	/// <summary>
	/// <para>
	/// Can be any span query.
	/// Matching spans from <c>big</c> that contain matches from <c>little</c> are returned.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery Little { get; set; }
	public string? QueryName { get; set; }
}

public readonly partial struct SpanContainingQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SpanContainingQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SpanContainingQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQuery(Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Can be any span query.
	/// Matching spans from <c>big</c> that contain matches from <c>little</c> are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQueryDescriptor<TDocument> Big(Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery value)
	{
		Instance.Big = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be any span query.
	/// Matching spans from <c>big</c> that contain matches from <c>little</c> are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQueryDescriptor<TDocument> Big(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor<TDocument>> action)
	{
		Instance.Big = Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be any span query.
	/// Matching spans from <c>big</c> that contain matches from <c>little</c> are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQueryDescriptor<TDocument> Little(Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery value)
	{
		Instance.Little = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be any span query.
	/// Matching spans from <c>big</c> that contain matches from <c>little</c> are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQueryDescriptor<TDocument> Little(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor<TDocument>> action)
	{
		Instance.Little = Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct SpanContainingQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SpanContainingQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SpanContainingQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQuery(Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Can be any span query.
	/// Matching spans from <c>big</c> that contain matches from <c>little</c> are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQueryDescriptor Big(Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery value)
	{
		Instance.Big = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be any span query.
	/// Matching spans from <c>big</c> that contain matches from <c>little</c> are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQueryDescriptor Big(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor> action)
	{
		Instance.Big = Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be any span query.
	/// Matching spans from <c>big</c> that contain matches from <c>little</c> are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQueryDescriptor Big<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor<T>> action)
	{
		Instance.Big = Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be any span query.
	/// Matching spans from <c>big</c> that contain matches from <c>little</c> are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQueryDescriptor Little(Elastic.Clients.Elasticsearch.QueryDsl.SpanQuery value)
	{
		Instance.Little = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be any span query.
	/// Matching spans from <c>big</c> that contain matches from <c>little</c> are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQueryDescriptor Little(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor> action)
	{
		Instance.Little = Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be any span query.
	/// Matching spans from <c>big</c> that contain matches from <c>little</c> are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQueryDescriptor Little<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor<T>> action)
	{
		Instance.Little = Elastic.Clients.Elasticsearch.QueryDsl.SpanQueryDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}