// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.SimpleQueryStringQueryConverter))]
public sealed partial class SimpleQueryStringQuery
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SimpleQueryStringQuery(string query)
	{
		Query = query;
	}
#if NET7_0_OR_GREATER
	public SimpleQueryStringQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public SimpleQueryStringQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SimpleQueryStringQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Analyzer used to convert text in the query string into tokens.
	/// </para>
	/// </summary>
	public string? Analyzer { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the query attempts to analyze wildcard terms in the query string.
	/// </para>
	/// </summary>
	public bool? AnalyzeWildcard { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the parser creates a match_phrase query for each multi-position token.
	/// </para>
	/// </summary>
	public bool? AutoGenerateSynonymsPhraseQuery { get; set; }

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }

	/// <summary>
	/// <para>
	/// Default boolean logic used to interpret text in the query string if no operators are specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.Operator? DefaultOperator { get; set; }

	/// <summary>
	/// <para>
	/// Array of fields you wish to search.
	/// Accepts wildcard expressions.
	/// You also can boost relevance scores for matches to particular fields using a caret (<c>^</c>) notation.
	/// Defaults to the <c>index.query.default_field index</c> setting, which has a default value of <c>*</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? Fields { get; set; }

	/// <summary>
	/// <para>
	/// List of enabled operators for the simple query string syntax.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags? Flags { get; set; }

	/// <summary>
	/// <para>
	/// Maximum number of terms to which the query expands for fuzzy matching.
	/// </para>
	/// </summary>
	public int? FuzzyMaxExpansions { get; set; }

	/// <summary>
	/// <para>
	/// Number of beginning characters left unchanged for fuzzy matching.
	/// </para>
	/// </summary>
	public int? FuzzyPrefixLength { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, edits for fuzzy matching include transpositions of two adjacent characters (for example, <c>ab</c> to <c>ba</c>).
	/// </para>
	/// </summary>
	public bool? FuzzyTranspositions { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, format-based errors, such as providing a text value for a numeric field, are ignored.
	/// </para>
	/// </summary>
	public bool? Lenient { get; set; }

	/// <summary>
	/// <para>
	/// Minimum number of clauses that must match for a document to be returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MinimumShouldMatch? MinimumShouldMatch { get; set; }

	/// <summary>
	/// <para>
	/// Query string in the simple query string syntax you wish to parse and use for search.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Query { get; set; }
	public string? QueryName { get; set; }

	/// <summary>
	/// <para>
	/// Suffix appended to quoted text in the query string.
	/// </para>
	/// </summary>
	public string? QuoteFieldSuffix { get; set; }
}

public readonly partial struct SimpleQueryStringQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SimpleQueryStringQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SimpleQueryStringQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQuery(Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Analyzer used to convert text in the query string into tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor<TDocument> Analyzer(string? value)
	{
		Instance.Analyzer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the query attempts to analyze wildcard terms in the query string.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor<TDocument> AnalyzeWildcard(bool? value = true)
	{
		Instance.AnalyzeWildcard = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the parser creates a match_phrase query for each multi-position token.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor<TDocument> AutoGenerateSynonymsPhraseQuery(bool? value = true)
	{
		Instance.AutoGenerateSynonymsPhraseQuery = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Default boolean logic used to interpret text in the query string if no operators are specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor<TDocument> DefaultOperator(Elastic.Clients.Elasticsearch.QueryDsl.Operator? value)
	{
		Instance.DefaultOperator = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of fields you wish to search.
	/// Accepts wildcard expressions.
	/// You also can boost relevance scores for matches to particular fields using a caret (<c>^</c>) notation.
	/// Defaults to the <c>index.query.default_field index</c> setting, which has a default value of <c>*</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor<TDocument> Fields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of fields you wish to search.
	/// Accepts wildcard expressions.
	/// You also can boost relevance scores for matches to particular fields using a caret (<c>^</c>) notation.
	/// Defaults to the <c>index.query.default_field index</c> setting, which has a default value of <c>*</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor<TDocument> Fields(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// List of enabled operators for the simple query string syntax.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor<TDocument> Flags(Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags? value)
	{
		Instance.Flags = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of terms to which the query expands for fuzzy matching.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor<TDocument> FuzzyMaxExpansions(int? value)
	{
		Instance.FuzzyMaxExpansions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of beginning characters left unchanged for fuzzy matching.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor<TDocument> FuzzyPrefixLength(int? value)
	{
		Instance.FuzzyPrefixLength = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, edits for fuzzy matching include transpositions of two adjacent characters (for example, <c>ab</c> to <c>ba</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor<TDocument> FuzzyTranspositions(bool? value = true)
	{
		Instance.FuzzyTranspositions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, format-based errors, such as providing a text value for a numeric field, are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor<TDocument> Lenient(bool? value = true)
	{
		Instance.Lenient = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum number of clauses that must match for a document to be returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor<TDocument> MinimumShouldMatch(Elastic.Clients.Elasticsearch.MinimumShouldMatch? value)
	{
		Instance.MinimumShouldMatch = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query string in the simple query string syntax you wish to parse and use for search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor<TDocument> Query(string value)
	{
		Instance.Query = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Suffix appended to quoted text in the query string.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor<TDocument> QuoteFieldSuffix(string? value)
	{
		Instance.QuoteFieldSuffix = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct SimpleQueryStringQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SimpleQueryStringQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SimpleQueryStringQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQuery(Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Analyzer used to convert text in the query string into tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor Analyzer(string? value)
	{
		Instance.Analyzer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the query attempts to analyze wildcard terms in the query string.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor AnalyzeWildcard(bool? value = true)
	{
		Instance.AnalyzeWildcard = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the parser creates a match_phrase query for each multi-position token.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor AutoGenerateSynonymsPhraseQuery(bool? value = true)
	{
		Instance.AutoGenerateSynonymsPhraseQuery = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Default boolean logic used to interpret text in the query string if no operators are specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor DefaultOperator(Elastic.Clients.Elasticsearch.QueryDsl.Operator? value)
	{
		Instance.DefaultOperator = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of fields you wish to search.
	/// Accepts wildcard expressions.
	/// You also can boost relevance scores for matches to particular fields using a caret (<c>^</c>) notation.
	/// Defaults to the <c>index.query.default_field index</c> setting, which has a default value of <c>*</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor Fields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of fields you wish to search.
	/// Accepts wildcard expressions.
	/// You also can boost relevance scores for matches to particular fields using a caret (<c>^</c>) notation.
	/// Defaults to the <c>index.query.default_field index</c> setting, which has a default value of <c>*</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor Fields<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// List of enabled operators for the simple query string syntax.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor Flags(Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags? value)
	{
		Instance.Flags = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of terms to which the query expands for fuzzy matching.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor FuzzyMaxExpansions(int? value)
	{
		Instance.FuzzyMaxExpansions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of beginning characters left unchanged for fuzzy matching.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor FuzzyPrefixLength(int? value)
	{
		Instance.FuzzyPrefixLength = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, edits for fuzzy matching include transpositions of two adjacent characters (for example, <c>ab</c> to <c>ba</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor FuzzyTranspositions(bool? value = true)
	{
		Instance.FuzzyTranspositions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, format-based errors, such as providing a text value for a numeric field, are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor Lenient(bool? value = true)
	{
		Instance.Lenient = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum number of clauses that must match for a document to be returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor MinimumShouldMatch(Elastic.Clients.Elasticsearch.MinimumShouldMatch? value)
	{
		Instance.MinimumShouldMatch = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query string in the simple query string syntax you wish to parse and use for search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor Query(string value)
	{
		Instance.Query = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Suffix appended to quoted text in the query string.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor QuoteFieldSuffix(string? value)
	{
		Instance.QuoteFieldSuffix = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}