// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl.Json;

public sealed partial class SimpleQueryStringFlagsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags>
{
	public override Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		{
			var s = reader.GetString();
			if (string.IsNullOrEmpty(s))
			{
				return default;
			}

			var flags = s.Split('|');
			var result = default(Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags);
			foreach (var flag in flags)
			{
				result |= flag switch
				{
					"ALL" => Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags.All,
					"AND" => Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags.And,
					"ESCAPE" => Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags.Escape,
					"FUZZY" => Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags.Fuzzy,
					"NEAR" => Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags.Near,
					"NONE" => Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags.None,
					"NOT" => Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags.Not,
					"OR" => Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags.Or,
					"PHRASE" => Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags.Phrase,
					"PRECEDENCE" => Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags.Precedence,
					"PREFIX" => Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags.Prefix,
					"SLOP" => Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags.Slop,
					"WHITESPACE" => Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags.Whitespace,
					_ => throw new System.Text.Json.JsonException($"Invalid flag value '{flag}' for type '{typeToConvert.Name}'.")
				};
			}

			return result;
		}
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags value, System.Text.Json.JsonSerializerOptions options)
	{
		{
			if (value == default)
			{
				writer.WriteStringValue(string.Empty);
				return;
			}

			var sb = new System.Text.StringBuilder();
			if (value.HasFlag(Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags.All))
				sb.Append("ALL|");
			if (value.HasFlag(Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags.And))
				sb.Append("AND|");
			if (value.HasFlag(Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags.Escape))
				sb.Append("ESCAPE|");
			if (value.HasFlag(Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags.Fuzzy))
				sb.Append("FUZZY|");
			if (value.HasFlag(Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags.Near))
				sb.Append("NEAR|");
			if (value.HasFlag(Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags.None))
				sb.Append("NONE|");
			if (value.HasFlag(Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags.Not))
				sb.Append("NOT|");
			if (value.HasFlag(Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags.Or))
				sb.Append("OR|");
			if (value.HasFlag(Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags.Phrase))
				sb.Append("PHRASE|");
			if (value.HasFlag(Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags.Precedence))
				sb.Append("PRECEDENCE|");
			if (value.HasFlag(Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags.Prefix))
				sb.Append("PREFIX|");
			if (value.HasFlag(Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags.Slop))
				sb.Append("SLOP|");
			if (value.HasFlag(Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringFlags.Whitespace))
				sb.Append("WHITESPACE|");
			if (sb.Length == 0)
			{
				writer.WriteStringValue(string.Empty);
				return;
			}

			sb.Remove(sb.Length - 1, 1);
			writer.WriteStringValue(sb.ToString());
		}
	}
}