// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.ShapeFieldQueryConverter))]
public sealed partial class ShapeFieldQuery
{
#if NET7_0_OR_GREATER
	public ShapeFieldQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public ShapeFieldQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ShapeFieldQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Queries using a pre-indexed shape.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FieldLookup? IndexedShape { get; set; }

	/// <summary>
	/// <para>
	/// Spatial relation between the query shape and the document shape.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GeoShapeRelation? Relation { get; set; }

	/// <summary>
	/// <para>
	/// Queries using an inline shape definition in GeoJSON or Well Known Text (WKT) format.
	/// </para>
	/// </summary>
	public object? Shape { get; set; }
}

public readonly partial struct ShapeFieldQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ShapeFieldQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ShapeFieldQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQuery(Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Queries using a pre-indexed shape.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQueryDescriptor<TDocument> IndexedShape(Elastic.Clients.Elasticsearch.QueryDsl.FieldLookup? value)
	{
		Instance.IndexedShape = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Queries using a pre-indexed shape.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQueryDescriptor<TDocument> IndexedShape(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldLookupDescriptor<TDocument>> action)
	{
		Instance.IndexedShape = Elastic.Clients.Elasticsearch.QueryDsl.FieldLookupDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Spatial relation between the query shape and the document shape.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQueryDescriptor<TDocument> Relation(Elastic.Clients.Elasticsearch.GeoShapeRelation? value)
	{
		Instance.Relation = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Queries using an inline shape definition in GeoJSON or Well Known Text (WKT) format.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQueryDescriptor<TDocument> Shape(object? value)
	{
		Instance.Shape = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQueryDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct ShapeFieldQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ShapeFieldQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ShapeFieldQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQuery(Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Queries using a pre-indexed shape.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQueryDescriptor IndexedShape(Elastic.Clients.Elasticsearch.QueryDsl.FieldLookup? value)
	{
		Instance.IndexedShape = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Queries using a pre-indexed shape.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQueryDescriptor IndexedShape(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldLookupDescriptor> action)
	{
		Instance.IndexedShape = Elastic.Clients.Elasticsearch.QueryDsl.FieldLookupDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Queries using a pre-indexed shape.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQueryDescriptor IndexedShape<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldLookupDescriptor<T>> action)
	{
		Instance.IndexedShape = Elastic.Clients.Elasticsearch.QueryDsl.FieldLookupDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Spatial relation between the query shape and the document shape.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQueryDescriptor Relation(Elastic.Clients.Elasticsearch.GeoShapeRelation? value)
	{
		Instance.Relation = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Queries using an inline shape definition in GeoJSON or Well Known Text (WKT) format.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQueryDescriptor Shape(object? value)
	{
		Instance.Shape = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQueryDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.ShapeFieldQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}