// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.RuleQueryConverter))]
public sealed partial class RuleQuery
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RuleQuery(object matchCriteria, Elastic.Clients.Elasticsearch.QueryDsl.Query organic)
	{
		MatchCriteria = matchCriteria;
		Organic = organic;
	}
#if NET7_0_OR_GREATER
	public RuleQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public RuleQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RuleQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	object MatchCriteria { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.QueryDsl.Query Organic { get; set; }
	public string? QueryName { get; set; }
	public string? RulesetId { get; set; }
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Id>? RulesetIds { get; set; }
}

public readonly partial struct RuleQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.RuleQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RuleQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.RuleQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RuleQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.RuleQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.RuleQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.RuleQuery(Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor<TDocument> MatchCriteria(object value)
	{
		Instance.MatchCriteria = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor<TDocument> Organic(Elastic.Clients.Elasticsearch.QueryDsl.Query value)
	{
		Instance.Organic = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor<TDocument> Organic(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.Organic = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor<TDocument> RulesetId(string? value)
	{
		Instance.RulesetId = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor<TDocument> RulesetIds(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Id>? value)
	{
		Instance.RulesetIds = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor<TDocument> RulesetIds(params Elastic.Clients.Elasticsearch.Id[] values)
	{
		Instance.RulesetIds = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.RuleQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.RuleQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct RuleQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.RuleQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RuleQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.RuleQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RuleQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.RuleQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.RuleQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.RuleQuery(Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor MatchCriteria(object value)
	{
		Instance.MatchCriteria = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor Organic(Elastic.Clients.Elasticsearch.QueryDsl.Query value)
	{
		Instance.Organic = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor Organic(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.Organic = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor Organic<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.Organic = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor RulesetId(string? value)
	{
		Instance.RulesetId = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor RulesetIds(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Id>? value)
	{
		Instance.RulesetIds = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor RulesetIds(params Elastic.Clients.Elasticsearch.Id[] values)
	{
		Instance.RulesetIds = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.RuleQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.RuleQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.RuleQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}