// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.RegexpQueryConverter))]
public sealed partial class RegexpQuery
{
	[System.Obsolete("The type contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public RegexpQuery(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RegexpQuery(Elastic.Clients.Elasticsearch.Field field, string value)
	{
		Field = field;
		Value = value;
	}
#if NET7_0_OR_GREATER
	public RegexpQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RegexpQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }

	/// <summary>
	/// <para>
	/// Allows case insensitive matching of the regular expression value with the indexed field values when set to <c>true</c>.
	/// When <c>false</c>, case sensitivity of matching depends on the underlying field’s mapping.
	/// </para>
	/// </summary>
	public bool? CaseInsensitive { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Enables optional operators for the regular expression.
	/// </para>
	/// </summary>
	public string? Flags { get; set; }

	/// <summary>
	/// <para>
	/// Maximum number of automaton states required for the query.
	/// </para>
	/// </summary>
	public int? MaxDeterminizedStates { get; set; }
	public string? QueryName { get; set; }

	/// <summary>
	/// <para>
	/// Method used to rewrite the query.
	/// </para>
	/// </summary>
	public string? Rewrite { get; set; }

	/// <summary>
	/// <para>
	/// Regular expression for terms you wish to find in the provided field.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Value { get; set; }
}

public readonly partial struct RegexpQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.RegexpQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RegexpQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.RegexpQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RegexpQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.RegexpQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.RegexpQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.RegexpQuery(Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Allows case insensitive matching of the regular expression value with the indexed field values when set to <c>true</c>.
	/// When <c>false</c>, case sensitivity of matching depends on the underlying field’s mapping.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor<TDocument> CaseInsensitive(bool? value = true)
	{
		Instance.CaseInsensitive = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Enables optional operators for the regular expression.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor<TDocument> Flags(string? value)
	{
		Instance.Flags = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of automaton states required for the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor<TDocument> MaxDeterminizedStates(int? value)
	{
		Instance.MaxDeterminizedStates = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Method used to rewrite the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor<TDocument> Rewrite(string? value)
	{
		Instance.Rewrite = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Regular expression for terms you wish to find in the provided field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor<TDocument> Value(string value)
	{
		Instance.Value = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.RegexpQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.RegexpQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct RegexpQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.RegexpQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RegexpQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.RegexpQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RegexpQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.RegexpQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.RegexpQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.RegexpQuery(Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Allows case insensitive matching of the regular expression value with the indexed field values when set to <c>true</c>.
	/// When <c>false</c>, case sensitivity of matching depends on the underlying field’s mapping.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor CaseInsensitive(bool? value = true)
	{
		Instance.CaseInsensitive = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Enables optional operators for the regular expression.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor Flags(string? value)
	{
		Instance.Flags = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of automaton states required for the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor MaxDeterminizedStates(int? value)
	{
		Instance.MaxDeterminizedStates = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Method used to rewrite the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor Rewrite(string? value)
	{
		Instance.Rewrite = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Regular expression for terms you wish to find in the provided field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor Value(string value)
	{
		Instance.Value = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.RegexpQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.RegexpQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.RegexpQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}