// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.RankFeatureQueryConverter))]
public sealed partial class RankFeatureQuery
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankFeatureQuery(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}
#if NET7_0_OR_GREATER
	public RankFeatureQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public RankFeatureQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RankFeatureQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }

	/// <summary>
	/// <para>
	/// <c>rank_feature</c> or <c>rank_features</c> field used to boost relevance scores.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Linear function used to boost relevance scores based on the value of the rank feature <c>field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionLinear? Linear { get; set; }

	/// <summary>
	/// <para>
	/// Logarithmic function used to boost relevance scores based on the value of the rank feature <c>field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionLogarithm? Log { get; set; }
	public string? QueryName { get; set; }

	/// <summary>
	/// <para>
	/// Saturation function used to boost relevance scores based on the value of the rank feature <c>field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSaturation? Saturation { get; set; }

	/// <summary>
	/// <para>
	/// Sigmoid function used to boost relevance scores based on the value of the rank feature <c>field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSigmoid? Sigmoid { get; set; }
}

public readonly partial struct RankFeatureQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankFeatureQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankFeatureQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQuery(Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// <c>rank_feature</c> or <c>rank_features</c> field used to boost relevance scores.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// <c>rank_feature</c> or <c>rank_features</c> field used to boost relevance scores.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Linear function used to boost relevance scores based on the value of the rank feature <c>field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor<TDocument> Linear(Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionLinear? value)
	{
		Instance.Linear = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Linear function used to boost relevance scores based on the value of the rank feature <c>field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor<TDocument> Linear()
	{
		Instance.Linear = Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionLinearDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Linear function used to boost relevance scores based on the value of the rank feature <c>field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor<TDocument> Linear(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionLinearDescriptor>? action)
	{
		Instance.Linear = Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionLinearDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Logarithmic function used to boost relevance scores based on the value of the rank feature <c>field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor<TDocument> Log(Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionLogarithm? value)
	{
		Instance.Log = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Logarithmic function used to boost relevance scores based on the value of the rank feature <c>field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor<TDocument> Log(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionLogarithmDescriptor> action)
	{
		Instance.Log = Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionLogarithmDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Saturation function used to boost relevance scores based on the value of the rank feature <c>field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor<TDocument> Saturation(Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSaturation? value)
	{
		Instance.Saturation = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Saturation function used to boost relevance scores based on the value of the rank feature <c>field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor<TDocument> Saturation()
	{
		Instance.Saturation = Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSaturationDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Saturation function used to boost relevance scores based on the value of the rank feature <c>field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor<TDocument> Saturation(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSaturationDescriptor>? action)
	{
		Instance.Saturation = Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSaturationDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Sigmoid function used to boost relevance scores based on the value of the rank feature <c>field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor<TDocument> Sigmoid(Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSigmoid? value)
	{
		Instance.Sigmoid = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Sigmoid function used to boost relevance scores based on the value of the rank feature <c>field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor<TDocument> Sigmoid(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSigmoidDescriptor> action)
	{
		Instance.Sigmoid = Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSigmoidDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct RankFeatureQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankFeatureQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankFeatureQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQuery(Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// <c>rank_feature</c> or <c>rank_features</c> field used to boost relevance scores.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// <c>rank_feature</c> or <c>rank_features</c> field used to boost relevance scores.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Linear function used to boost relevance scores based on the value of the rank feature <c>field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor Linear(Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionLinear? value)
	{
		Instance.Linear = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Linear function used to boost relevance scores based on the value of the rank feature <c>field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor Linear()
	{
		Instance.Linear = Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionLinearDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Linear function used to boost relevance scores based on the value of the rank feature <c>field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor Linear(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionLinearDescriptor>? action)
	{
		Instance.Linear = Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionLinearDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Logarithmic function used to boost relevance scores based on the value of the rank feature <c>field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor Log(Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionLogarithm? value)
	{
		Instance.Log = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Logarithmic function used to boost relevance scores based on the value of the rank feature <c>field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor Log(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionLogarithmDescriptor> action)
	{
		Instance.Log = Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionLogarithmDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Saturation function used to boost relevance scores based on the value of the rank feature <c>field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor Saturation(Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSaturation? value)
	{
		Instance.Saturation = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Saturation function used to boost relevance scores based on the value of the rank feature <c>field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor Saturation()
	{
		Instance.Saturation = Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSaturationDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Saturation function used to boost relevance scores based on the value of the rank feature <c>field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor Saturation(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSaturationDescriptor>? action)
	{
		Instance.Saturation = Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSaturationDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Sigmoid function used to boost relevance scores based on the value of the rank feature <c>field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor Sigmoid(Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSigmoid? value)
	{
		Instance.Sigmoid = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Sigmoid function used to boost relevance scores based on the value of the rank feature <c>field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor Sigmoid(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSigmoidDescriptor> action)
	{
		Instance.Sigmoid = Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSigmoidDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}