// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.RankFeatureFunctionSigmoidConverter))]
public sealed partial class RankFeatureFunctionSigmoid
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankFeatureFunctionSigmoid(float exponent, float pivot)
	{
		Exponent = exponent;
		Pivot = pivot;
	}
#if NET7_0_OR_GREATER
	public RankFeatureFunctionSigmoid()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public RankFeatureFunctionSigmoid()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RankFeatureFunctionSigmoid(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Configurable Exponent.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	float Exponent { get; set; }

	/// <summary>
	/// <para>
	/// Configurable pivot value so that the result will be less than 0.5.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	float Pivot { get; set; }
}

public readonly partial struct RankFeatureFunctionSigmoidDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSigmoid Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankFeatureFunctionSigmoidDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSigmoid instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankFeatureFunctionSigmoidDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSigmoid(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSigmoidDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSigmoid instance) => new Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSigmoidDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSigmoid(Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSigmoidDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Configurable Exponent.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSigmoidDescriptor Exponent(float value)
	{
		Instance.Exponent = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configurable pivot value so that the result will be less than 0.5.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSigmoidDescriptor Pivot(float value)
	{
		Instance.Pivot = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSigmoid Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSigmoidDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSigmoidDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureFunctionSigmoid(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}