// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl.Json;

public sealed partial class RangeRelationConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation>
{
	private static readonly System.Text.Json.JsonEncodedText MemberContains = System.Text.Json.JsonEncodedText.Encode("contains");
	private static readonly System.Text.Json.JsonEncodedText MemberIntersects = System.Text.Json.JsonEncodedText.Encode("intersects");
	private static readonly System.Text.Json.JsonEncodedText MemberWithin = System.Text.Json.JsonEncodedText.Encode("within");

	public override Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberContains))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation.Contains;
		}

		if (reader.ValueTextEquals(MemberIntersects))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation.Intersects;
		}

		if (reader.ValueTextEquals(MemberWithin))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation.Within;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberContains.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation.Contains;
		}

		if (string.Equals(value, MemberIntersects.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation.Intersects;
		}

		if (string.Equals(value, MemberWithin.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation.Within;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation.Contains:
				writer.WriteStringValue(MemberContains);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation.Intersects:
				writer.WriteStringValue(MemberIntersects);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation.Within:
				writer.WriteStringValue(MemberWithin);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}