// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.QueryStringQueryConverter))]
public sealed partial class QueryStringQuery
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public QueryStringQuery(string query)
	{
		Query = query;
	}
#if NET7_0_OR_GREATER
	public QueryStringQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public QueryStringQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal QueryStringQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the wildcard characters <c>*</c> and <c>?</c> are allowed as the first character of the query string.
	/// </para>
	/// </summary>
	public bool? AllowLeadingWildcard { get; set; }

	/// <summary>
	/// <para>
	/// Analyzer used to convert text in the query string into tokens.
	/// </para>
	/// </summary>
	public string? Analyzer { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the query attempts to analyze wildcard terms in the query string.
	/// </para>
	/// </summary>
	public bool? AnalyzeWildcard { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, match phrase queries are automatically created for multi-term synonyms.
	/// </para>
	/// </summary>
	public bool? AutoGenerateSynonymsPhraseQuery { get; set; }

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }

	/// <summary>
	/// <para>
	/// Default field to search if no field is provided in the query string.
	/// Supports wildcards (<c>*</c>).
	/// Defaults to the <c>index.query.default_field</c> index setting, which has a default value of <c>*</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? DefaultField { get; set; }

	/// <summary>
	/// <para>
	/// Default boolean logic used to interpret text in the query string if no operators are specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.Operator? DefaultOperator { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, enable position increments in queries constructed from a <c>query_string</c> search.
	/// </para>
	/// </summary>
	public bool? EnablePositionIncrements { get; set; }
	public bool? Escape { get; set; }

	/// <summary>
	/// <para>
	/// Array of fields to search. Supports wildcards (<c>*</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? Fields { get; set; }

	/// <summary>
	/// <para>
	/// Maximum edit distance allowed for fuzzy matching.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fuzziness? Fuzziness { get; set; }

	/// <summary>
	/// <para>
	/// Maximum number of terms to which the query expands for fuzzy matching.
	/// </para>
	/// </summary>
	public int? FuzzyMaxExpansions { get; set; }

	/// <summary>
	/// <para>
	/// Number of beginning characters left unchanged for fuzzy matching.
	/// </para>
	/// </summary>
	public int? FuzzyPrefixLength { get; set; }

	/// <summary>
	/// <para>
	/// Method used to rewrite the query.
	/// </para>
	/// </summary>
	public string? FuzzyRewrite { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, edits for fuzzy matching include transpositions of two adjacent characters (for example, <c>ab</c> to <c>ba</c>).
	/// </para>
	/// </summary>
	public bool? FuzzyTranspositions { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, format-based errors, such as providing a text value for a numeric field, are ignored.
	/// </para>
	/// </summary>
	public bool? Lenient { get; set; }

	/// <summary>
	/// <para>
	/// Maximum number of automaton states required for the query.
	/// </para>
	/// </summary>
	public int? MaxDeterminizedStates { get; set; }

	/// <summary>
	/// <para>
	/// Minimum number of clauses that must match for a document to be returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MinimumShouldMatch? MinimumShouldMatch { get; set; }

	/// <summary>
	/// <para>
	/// Maximum number of positions allowed between matching tokens for phrases.
	/// </para>
	/// </summary>
	public double? PhraseSlop { get; set; }

	/// <summary>
	/// <para>
	/// Query string you wish to parse and use for search.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Query { get; set; }
	public string? QueryName { get; set; }

	/// <summary>
	/// <para>
	/// Analyzer used to convert quoted text in the query string into tokens.
	/// For quoted text, this parameter overrides the analyzer specified in the <c>analyzer</c> parameter.
	/// </para>
	/// </summary>
	public string? QuoteAnalyzer { get; set; }

	/// <summary>
	/// <para>
	/// Suffix appended to quoted text in the query string.
	/// You can use this suffix to use a different analysis method for exact matches.
	/// </para>
	/// </summary>
	public string? QuoteFieldSuffix { get; set; }

	/// <summary>
	/// <para>
	/// Method used to rewrite the query.
	/// </para>
	/// </summary>
	public string? Rewrite { get; set; }

	/// <summary>
	/// <para>
	/// How to combine the queries generated from the individual search terms in the resulting <c>dis_max</c> query.
	/// </para>
	/// </summary>
	public double? TieBreaker { get; set; }

	/// <summary>
	/// <para>
	/// Coordinated Universal Time (UTC) offset or IANA time zone used to convert date values in the query string to UTC.
	/// </para>
	/// </summary>
	public string? TimeZone { get; set; }

	/// <summary>
	/// <para>
	/// Determines how the query matches and scores documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType? Type { get; set; }
}

public readonly partial struct QueryStringQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public QueryStringQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public QueryStringQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQuery(Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If <c>true</c>, the wildcard characters <c>*</c> and <c>?</c> are allowed as the first character of the query string.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> AllowLeadingWildcard(bool? value = true)
	{
		Instance.AllowLeadingWildcard = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Analyzer used to convert text in the query string into tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> Analyzer(string? value)
	{
		Instance.Analyzer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the query attempts to analyze wildcard terms in the query string.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> AnalyzeWildcard(bool? value = true)
	{
		Instance.AnalyzeWildcard = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, match phrase queries are automatically created for multi-term synonyms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> AutoGenerateSynonymsPhraseQuery(bool? value = true)
	{
		Instance.AutoGenerateSynonymsPhraseQuery = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Default field to search if no field is provided in the query string.
	/// Supports wildcards (<c>*</c>).
	/// Defaults to the <c>index.query.default_field</c> index setting, which has a default value of <c>*</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> DefaultField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.DefaultField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Default field to search if no field is provided in the query string.
	/// Supports wildcards (<c>*</c>).
	/// Defaults to the <c>index.query.default_field</c> index setting, which has a default value of <c>*</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> DefaultField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.DefaultField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Default boolean logic used to interpret text in the query string if no operators are specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> DefaultOperator(Elastic.Clients.Elasticsearch.QueryDsl.Operator? value)
	{
		Instance.DefaultOperator = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, enable position increments in queries constructed from a <c>query_string</c> search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> EnablePositionIncrements(bool? value = true)
	{
		Instance.EnablePositionIncrements = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> Escape(bool? value = true)
	{
		Instance.Escape = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of fields to search. Supports wildcards (<c>*</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> Fields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of fields to search. Supports wildcards (<c>*</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> Fields(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum edit distance allowed for fuzzy matching.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> Fuzziness(Elastic.Clients.Elasticsearch.Fuzziness? value)
	{
		Instance.Fuzziness = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum edit distance allowed for fuzzy matching.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> Fuzziness(System.Func<Elastic.Clients.Elasticsearch.FuzzinessFactory, Elastic.Clients.Elasticsearch.Fuzziness> action)
	{
		Instance.Fuzziness = Elastic.Clients.Elasticsearch.FuzzinessFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of terms to which the query expands for fuzzy matching.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> FuzzyMaxExpansions(int? value)
	{
		Instance.FuzzyMaxExpansions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of beginning characters left unchanged for fuzzy matching.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> FuzzyPrefixLength(int? value)
	{
		Instance.FuzzyPrefixLength = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Method used to rewrite the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> FuzzyRewrite(string? value)
	{
		Instance.FuzzyRewrite = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, edits for fuzzy matching include transpositions of two adjacent characters (for example, <c>ab</c> to <c>ba</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> FuzzyTranspositions(bool? value = true)
	{
		Instance.FuzzyTranspositions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, format-based errors, such as providing a text value for a numeric field, are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> Lenient(bool? value = true)
	{
		Instance.Lenient = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of automaton states required for the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> MaxDeterminizedStates(int? value)
	{
		Instance.MaxDeterminizedStates = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum number of clauses that must match for a document to be returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> MinimumShouldMatch(Elastic.Clients.Elasticsearch.MinimumShouldMatch? value)
	{
		Instance.MinimumShouldMatch = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of positions allowed between matching tokens for phrases.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> PhraseSlop(double? value)
	{
		Instance.PhraseSlop = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query string you wish to parse and use for search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> Query(string value)
	{
		Instance.Query = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Analyzer used to convert quoted text in the query string into tokens.
	/// For quoted text, this parameter overrides the analyzer specified in the <c>analyzer</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> QuoteAnalyzer(string? value)
	{
		Instance.QuoteAnalyzer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Suffix appended to quoted text in the query string.
	/// You can use this suffix to use a different analysis method for exact matches.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> QuoteFieldSuffix(string? value)
	{
		Instance.QuoteFieldSuffix = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Method used to rewrite the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> Rewrite(string? value)
	{
		Instance.Rewrite = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// How to combine the queries generated from the individual search terms in the resulting <c>dis_max</c> query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> TieBreaker(double? value)
	{
		Instance.TieBreaker = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Coordinated Universal Time (UTC) offset or IANA time zone used to convert date values in the query string to UTC.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> TimeZone(string? value)
	{
		Instance.TimeZone = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Determines how the query matches and scores documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument> Type(Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType? value)
	{
		Instance.Type = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct QueryStringQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public QueryStringQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public QueryStringQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQuery(Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If <c>true</c>, the wildcard characters <c>*</c> and <c>?</c> are allowed as the first character of the query string.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor AllowLeadingWildcard(bool? value = true)
	{
		Instance.AllowLeadingWildcard = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Analyzer used to convert text in the query string into tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor Analyzer(string? value)
	{
		Instance.Analyzer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the query attempts to analyze wildcard terms in the query string.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor AnalyzeWildcard(bool? value = true)
	{
		Instance.AnalyzeWildcard = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, match phrase queries are automatically created for multi-term synonyms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor AutoGenerateSynonymsPhraseQuery(bool? value = true)
	{
		Instance.AutoGenerateSynonymsPhraseQuery = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Default field to search if no field is provided in the query string.
	/// Supports wildcards (<c>*</c>).
	/// Defaults to the <c>index.query.default_field</c> index setting, which has a default value of <c>*</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor DefaultField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.DefaultField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Default field to search if no field is provided in the query string.
	/// Supports wildcards (<c>*</c>).
	/// Defaults to the <c>index.query.default_field</c> index setting, which has a default value of <c>*</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor DefaultField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.DefaultField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Default boolean logic used to interpret text in the query string if no operators are specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor DefaultOperator(Elastic.Clients.Elasticsearch.QueryDsl.Operator? value)
	{
		Instance.DefaultOperator = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, enable position increments in queries constructed from a <c>query_string</c> search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor EnablePositionIncrements(bool? value = true)
	{
		Instance.EnablePositionIncrements = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor Escape(bool? value = true)
	{
		Instance.Escape = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of fields to search. Supports wildcards (<c>*</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor Fields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of fields to search. Supports wildcards (<c>*</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor Fields<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum edit distance allowed for fuzzy matching.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor Fuzziness(Elastic.Clients.Elasticsearch.Fuzziness? value)
	{
		Instance.Fuzziness = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum edit distance allowed for fuzzy matching.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor Fuzziness(System.Func<Elastic.Clients.Elasticsearch.FuzzinessFactory, Elastic.Clients.Elasticsearch.Fuzziness> action)
	{
		Instance.Fuzziness = Elastic.Clients.Elasticsearch.FuzzinessFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of terms to which the query expands for fuzzy matching.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor FuzzyMaxExpansions(int? value)
	{
		Instance.FuzzyMaxExpansions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of beginning characters left unchanged for fuzzy matching.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor FuzzyPrefixLength(int? value)
	{
		Instance.FuzzyPrefixLength = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Method used to rewrite the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor FuzzyRewrite(string? value)
	{
		Instance.FuzzyRewrite = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, edits for fuzzy matching include transpositions of two adjacent characters (for example, <c>ab</c> to <c>ba</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor FuzzyTranspositions(bool? value = true)
	{
		Instance.FuzzyTranspositions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, format-based errors, such as providing a text value for a numeric field, are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor Lenient(bool? value = true)
	{
		Instance.Lenient = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of automaton states required for the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor MaxDeterminizedStates(int? value)
	{
		Instance.MaxDeterminizedStates = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum number of clauses that must match for a document to be returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor MinimumShouldMatch(Elastic.Clients.Elasticsearch.MinimumShouldMatch? value)
	{
		Instance.MinimumShouldMatch = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of positions allowed between matching tokens for phrases.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor PhraseSlop(double? value)
	{
		Instance.PhraseSlop = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query string you wish to parse and use for search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor Query(string value)
	{
		Instance.Query = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Analyzer used to convert quoted text in the query string into tokens.
	/// For quoted text, this parameter overrides the analyzer specified in the <c>analyzer</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor QuoteAnalyzer(string? value)
	{
		Instance.QuoteAnalyzer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Suffix appended to quoted text in the query string.
	/// You can use this suffix to use a different analysis method for exact matches.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor QuoteFieldSuffix(string? value)
	{
		Instance.QuoteFieldSuffix = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Method used to rewrite the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor Rewrite(string? value)
	{
		Instance.Rewrite = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// How to combine the queries generated from the individual search terms in the resulting <c>dis_max</c> query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor TieBreaker(double? value)
	{
		Instance.TieBreaker = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Coordinated Universal Time (UTC) offset or IANA time zone used to convert date values in the query string to UTC.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor TimeZone(string? value)
	{
		Instance.TimeZone = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Determines how the query matches and scores documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor Type(Elastic.Clients.Elasticsearch.QueryDsl.TextQueryType? value)
	{
		Instance.Type = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}