// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl.Json;

public sealed partial class QueryConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.QueryDsl.Query>
{
	private static readonly System.Text.Json.JsonEncodedText VariantBool = System.Text.Json.JsonEncodedText.Encode("bool");
	private static readonly System.Text.Json.JsonEncodedText VariantBoosting = System.Text.Json.JsonEncodedText.Encode("boosting");
	private static readonly System.Text.Json.JsonEncodedText VariantCombinedFields = System.Text.Json.JsonEncodedText.Encode("combined_fields");
	private static readonly System.Text.Json.JsonEncodedText VariantCommon = System.Text.Json.JsonEncodedText.Encode("common");
	private static readonly System.Text.Json.JsonEncodedText VariantConstantScore = System.Text.Json.JsonEncodedText.Encode("constant_score");
	private static readonly System.Text.Json.JsonEncodedText VariantDisMax = System.Text.Json.JsonEncodedText.Encode("dis_max");
	private static readonly System.Text.Json.JsonEncodedText VariantDistanceFeature = System.Text.Json.JsonEncodedText.Encode("distance_feature");
	private static readonly System.Text.Json.JsonEncodedText VariantExists = System.Text.Json.JsonEncodedText.Encode("exists");
	private static readonly System.Text.Json.JsonEncodedText VariantFunctionScore = System.Text.Json.JsonEncodedText.Encode("function_score");
	private static readonly System.Text.Json.JsonEncodedText VariantFuzzy = System.Text.Json.JsonEncodedText.Encode("fuzzy");
	private static readonly System.Text.Json.JsonEncodedText VariantGeoBoundingBox = System.Text.Json.JsonEncodedText.Encode("geo_bounding_box");
	private static readonly System.Text.Json.JsonEncodedText VariantGeoDistance = System.Text.Json.JsonEncodedText.Encode("geo_distance");
	private static readonly System.Text.Json.JsonEncodedText VariantGeoGrid = System.Text.Json.JsonEncodedText.Encode("geo_grid");
	private static readonly System.Text.Json.JsonEncodedText VariantGeoPolygon = System.Text.Json.JsonEncodedText.Encode("geo_polygon");
	private static readonly System.Text.Json.JsonEncodedText VariantGeoShape = System.Text.Json.JsonEncodedText.Encode("geo_shape");
	private static readonly System.Text.Json.JsonEncodedText VariantHasChild = System.Text.Json.JsonEncodedText.Encode("has_child");
	private static readonly System.Text.Json.JsonEncodedText VariantHasParent = System.Text.Json.JsonEncodedText.Encode("has_parent");
	private static readonly System.Text.Json.JsonEncodedText VariantIds = System.Text.Json.JsonEncodedText.Encode("ids");
	private static readonly System.Text.Json.JsonEncodedText VariantIntervals = System.Text.Json.JsonEncodedText.Encode("intervals");
	private static readonly System.Text.Json.JsonEncodedText VariantKnn = System.Text.Json.JsonEncodedText.Encode("knn");
	private static readonly System.Text.Json.JsonEncodedText VariantMatch = System.Text.Json.JsonEncodedText.Encode("match");
	private static readonly System.Text.Json.JsonEncodedText VariantMatchAll = System.Text.Json.JsonEncodedText.Encode("match_all");
	private static readonly System.Text.Json.JsonEncodedText VariantMatchBoolPrefix = System.Text.Json.JsonEncodedText.Encode("match_bool_prefix");
	private static readonly System.Text.Json.JsonEncodedText VariantMatchNone = System.Text.Json.JsonEncodedText.Encode("match_none");
	private static readonly System.Text.Json.JsonEncodedText VariantMatchPhrase = System.Text.Json.JsonEncodedText.Encode("match_phrase");
	private static readonly System.Text.Json.JsonEncodedText VariantMatchPhrasePrefix = System.Text.Json.JsonEncodedText.Encode("match_phrase_prefix");
	private static readonly System.Text.Json.JsonEncodedText VariantMoreLikeThis = System.Text.Json.JsonEncodedText.Encode("more_like_this");
	private static readonly System.Text.Json.JsonEncodedText VariantMultiMatch = System.Text.Json.JsonEncodedText.Encode("multi_match");
	private static readonly System.Text.Json.JsonEncodedText VariantNested = System.Text.Json.JsonEncodedText.Encode("nested");
	private static readonly System.Text.Json.JsonEncodedText VariantParentId = System.Text.Json.JsonEncodedText.Encode("parent_id");
	private static readonly System.Text.Json.JsonEncodedText VariantPercolate = System.Text.Json.JsonEncodedText.Encode("percolate");
	private static readonly System.Text.Json.JsonEncodedText VariantPinned = System.Text.Json.JsonEncodedText.Encode("pinned");
	private static readonly System.Text.Json.JsonEncodedText VariantPrefix = System.Text.Json.JsonEncodedText.Encode("prefix");
	private static readonly System.Text.Json.JsonEncodedText VariantQueryString = System.Text.Json.JsonEncodedText.Encode("query_string");
	private static readonly System.Text.Json.JsonEncodedText VariantRange = System.Text.Json.JsonEncodedText.Encode("range");
	private static readonly System.Text.Json.JsonEncodedText VariantRankFeature = System.Text.Json.JsonEncodedText.Encode("rank_feature");
	private static readonly System.Text.Json.JsonEncodedText VariantRegexp = System.Text.Json.JsonEncodedText.Encode("regexp");
	private static readonly System.Text.Json.JsonEncodedText VariantRule = System.Text.Json.JsonEncodedText.Encode("rule");
	private static readonly System.Text.Json.JsonEncodedText VariantScript = System.Text.Json.JsonEncodedText.Encode("script");
	private static readonly System.Text.Json.JsonEncodedText VariantScriptScore = System.Text.Json.JsonEncodedText.Encode("script_score");
	private static readonly System.Text.Json.JsonEncodedText VariantSemantic = System.Text.Json.JsonEncodedText.Encode("semantic");
	private static readonly System.Text.Json.JsonEncodedText VariantShape = System.Text.Json.JsonEncodedText.Encode("shape");
	private static readonly System.Text.Json.JsonEncodedText VariantSimpleQueryString = System.Text.Json.JsonEncodedText.Encode("simple_query_string");
	private static readonly System.Text.Json.JsonEncodedText VariantSpanContaining = System.Text.Json.JsonEncodedText.Encode("span_containing");
	private static readonly System.Text.Json.JsonEncodedText VariantSpanFieldMasking = System.Text.Json.JsonEncodedText.Encode("span_field_masking");
	private static readonly System.Text.Json.JsonEncodedText VariantSpanFirst = System.Text.Json.JsonEncodedText.Encode("span_first");
	private static readonly System.Text.Json.JsonEncodedText VariantSpanMulti = System.Text.Json.JsonEncodedText.Encode("span_multi");
	private static readonly System.Text.Json.JsonEncodedText VariantSpanNear = System.Text.Json.JsonEncodedText.Encode("span_near");
	private static readonly System.Text.Json.JsonEncodedText VariantSpanNot = System.Text.Json.JsonEncodedText.Encode("span_not");
	private static readonly System.Text.Json.JsonEncodedText VariantSpanOr = System.Text.Json.JsonEncodedText.Encode("span_or");
	private static readonly System.Text.Json.JsonEncodedText VariantSpanTerm = System.Text.Json.JsonEncodedText.Encode("span_term");
	private static readonly System.Text.Json.JsonEncodedText VariantSpanWithin = System.Text.Json.JsonEncodedText.Encode("span_within");
	private static readonly System.Text.Json.JsonEncodedText VariantSparseVector = System.Text.Json.JsonEncodedText.Encode("sparse_vector");
	private static readonly System.Text.Json.JsonEncodedText VariantTerm = System.Text.Json.JsonEncodedText.Encode("term");
	private static readonly System.Text.Json.JsonEncodedText VariantTerms = System.Text.Json.JsonEncodedText.Encode("terms");
	private static readonly System.Text.Json.JsonEncodedText VariantTermsSet = System.Text.Json.JsonEncodedText.Encode("terms_set");
	private static readonly System.Text.Json.JsonEncodedText VariantTextExpansion = System.Text.Json.JsonEncodedText.Encode("text_expansion");
	private static readonly System.Text.Json.JsonEncodedText VariantType = System.Text.Json.JsonEncodedText.Encode("type");
	private static readonly System.Text.Json.JsonEncodedText VariantWeightedTokens = System.Text.Json.JsonEncodedText.Encode("weighted_tokens");
	private static readonly System.Text.Json.JsonEncodedText VariantWildcard = System.Text.Json.JsonEncodedText.Encode("wildcard");
	private static readonly System.Text.Json.JsonEncodedText VariantWrapper = System.Text.Json.JsonEncodedText.Encode("wrapper");

	public override Elastic.Clients.Elasticsearch.QueryDsl.Query Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		string? variantType = null;
		object? variant = null;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (reader.ValueTextEquals(VariantBool))
			{
				variantType = VariantBool.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.BoolQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantBoosting))
			{
				variantType = VariantBoosting.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.BoostingQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantCombinedFields))
			{
				variantType = VariantCombinedFields.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantCommon))
			{
				variantType = VariantCommon.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantConstantScore))
			{
				variantType = VariantConstantScore.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantDisMax))
			{
				variantType = VariantDisMax.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantDistanceFeature))
			{
				variantType = VariantDistanceFeature.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.IDistanceFeatureQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantExists))
			{
				variantType = VariantExists.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.ExistsQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantFunctionScore))
			{
				variantType = VariantFunctionScore.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantFuzzy))
			{
				variantType = VariantFuzzy.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantGeoBoundingBox))
			{
				variantType = VariantGeoBoundingBox.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantGeoDistance))
			{
				variantType = VariantGeoDistance.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.GeoDistanceQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantGeoGrid))
			{
				variantType = VariantGeoGrid.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.GeoGridQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantGeoPolygon))
			{
				variantType = VariantGeoPolygon.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantGeoShape))
			{
				variantType = VariantGeoShape.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantHasChild))
			{
				variantType = VariantHasChild.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.HasChildQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantHasParent))
			{
				variantType = VariantHasParent.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.HasParentQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantIds))
			{
				variantType = VariantIds.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.IdsQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantIntervals))
			{
				variantType = VariantIntervals.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.IntervalsQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantKnn))
			{
				variantType = VariantKnn.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.KnnQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantMatch))
			{
				variantType = VariantMatch.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.MatchQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantMatchAll))
			{
				variantType = VariantMatchAll.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.MatchAllQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantMatchBoolPrefix))
			{
				variantType = VariantMatchBoolPrefix.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantMatchNone))
			{
				variantType = VariantMatchNone.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.MatchNoneQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantMatchPhrase))
			{
				variantType = VariantMatchPhrase.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantMatchPhrasePrefix))
			{
				variantType = VariantMatchPhrasePrefix.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.MatchPhrasePrefixQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantMoreLikeThis))
			{
				variantType = VariantMoreLikeThis.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantMultiMatch))
			{
				variantType = VariantMultiMatch.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.MultiMatchQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantNested))
			{
				variantType = VariantNested.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.NestedQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantParentId))
			{
				variantType = VariantParentId.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.ParentIdQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantPercolate))
			{
				variantType = VariantPercolate.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.PercolateQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantPinned))
			{
				variantType = VariantPinned.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.PinnedQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantPrefix))
			{
				variantType = VariantPrefix.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.PrefixQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantQueryString))
			{
				variantType = VariantQueryString.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantRange))
			{
				variantType = VariantRange.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.IRangeQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantRankFeature))
			{
				variantType = VariantRankFeature.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantRegexp))
			{
				variantType = VariantRegexp.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.RegexpQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantRule))
			{
				variantType = VariantRule.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.RuleQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantScript))
			{
				variantType = VariantScript.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.ScriptQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantScriptScore))
			{
				variantType = VariantScriptScore.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.ScriptScoreQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSemantic))
			{
				variantType = VariantSemantic.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.SemanticQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantShape))
			{
				variantType = VariantShape.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.ShapeQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSimpleQueryString))
			{
				variantType = VariantSimpleQueryString.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSpanContaining))
			{
				variantType = VariantSpanContaining.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSpanFieldMasking))
			{
				variantType = VariantSpanFieldMasking.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.SpanFieldMaskingQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSpanFirst))
			{
				variantType = VariantSpanFirst.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.SpanFirstQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSpanMulti))
			{
				variantType = VariantSpanMulti.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.SpanMultiTermQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSpanNear))
			{
				variantType = VariantSpanNear.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.SpanNearQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSpanNot))
			{
				variantType = VariantSpanNot.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSpanOr))
			{
				variantType = VariantSpanOr.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.SpanOrQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSpanTerm))
			{
				variantType = VariantSpanTerm.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.SpanTermQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSpanWithin))
			{
				variantType = VariantSpanWithin.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSparseVector))
			{
				variantType = VariantSparseVector.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantTerm))
			{
				variantType = VariantTerm.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.TermQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantTerms))
			{
				variantType = VariantTerms.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.TermsQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantTermsSet))
			{
				variantType = VariantTermsSet.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.TermsSetQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantTextExpansion))
			{
				variantType = VariantTextExpansion.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantType))
			{
				variantType = VariantType.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.TypeQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantWeightedTokens))
			{
				variantType = VariantWeightedTokens.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantWildcard))
			{
				variantType = VariantWildcard.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.WildcardQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantWrapper))
			{
				variantType = VariantWrapper.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.WrapperQuery>(options, null);
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.QueryDsl.Query(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			VariantType = variantType,
			Variant = variant
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.QueryDsl.Query value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		switch (value.VariantType)
		{
			case null:
				break;
			case "bool":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.BoolQuery)value.Variant, null, null);
				break;
			case "boosting":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.BoostingQuery)value.Variant, null, null);
				break;
			case "combined_fields":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQuery)value.Variant, null, null);
				break;
			case "common":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQuery)value.Variant, null, null);
				break;
			case "constant_score":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQuery)value.Variant, null, null);
				break;
			case "dis_max":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQuery)value.Variant, null, null);
				break;
			case "distance_feature":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.IDistanceFeatureQuery)value.Variant, null, null);
				break;
			case "exists":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.ExistsQuery)value.Variant, null, null);
				break;
			case "function_score":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQuery)value.Variant, null, null);
				break;
			case "fuzzy":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQuery)value.Variant, null, null);
				break;
			case "geo_bounding_box":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQuery)value.Variant, null, null);
				break;
			case "geo_distance":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.GeoDistanceQuery)value.Variant, null, null);
				break;
			case "geo_grid":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.GeoGridQuery)value.Variant, null, null);
				break;
			case "geo_polygon":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQuery)value.Variant, null, null);
				break;
			case "geo_shape":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQuery)value.Variant, null, null);
				break;
			case "has_child":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.HasChildQuery)value.Variant, null, null);
				break;
			case "has_parent":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.HasParentQuery)value.Variant, null, null);
				break;
			case "ids":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.IdsQuery)value.Variant, null, null);
				break;
			case "intervals":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.IntervalsQuery)value.Variant, null, null);
				break;
			case "knn":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.KnnQuery)value.Variant, null, null);
				break;
			case "match":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.MatchQuery)value.Variant, null, null);
				break;
			case "match_all":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.MatchAllQuery)value.Variant, null, null);
				break;
			case "match_bool_prefix":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQuery)value.Variant, null, null);
				break;
			case "match_none":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.MatchNoneQuery)value.Variant, null, null);
				break;
			case "match_phrase":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQuery)value.Variant, null, null);
				break;
			case "match_phrase_prefix":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.MatchPhrasePrefixQuery)value.Variant, null, null);
				break;
			case "more_like_this":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQuery)value.Variant, null, null);
				break;
			case "multi_match":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.MultiMatchQuery)value.Variant, null, null);
				break;
			case "nested":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.NestedQuery)value.Variant, null, null);
				break;
			case "parent_id":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.ParentIdQuery)value.Variant, null, null);
				break;
			case "percolate":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.PercolateQuery)value.Variant, null, null);
				break;
			case "pinned":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.PinnedQuery)value.Variant, null, null);
				break;
			case "prefix":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.PrefixQuery)value.Variant, null, null);
				break;
			case "query_string":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.QueryStringQuery)value.Variant, null, null);
				break;
			case "range":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.IRangeQuery)value.Variant, null, null);
				break;
			case "rank_feature":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.RankFeatureQuery)value.Variant, null, null);
				break;
			case "regexp":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.RegexpQuery)value.Variant, null, null);
				break;
			case "rule":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.RuleQuery)value.Variant, null, null);
				break;
			case "script":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.ScriptQuery)value.Variant, null, null);
				break;
			case "script_score":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.ScriptScoreQuery)value.Variant, null, null);
				break;
			case "semantic":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.SemanticQuery)value.Variant, null, null);
				break;
			case "shape":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.ShapeQuery)value.Variant, null, null);
				break;
			case "simple_query_string":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQuery)value.Variant, null, null);
				break;
			case "span_containing":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.SpanContainingQuery)value.Variant, null, null);
				break;
			case "span_field_masking":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.SpanFieldMaskingQuery)value.Variant, null, null);
				break;
			case "span_first":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.SpanFirstQuery)value.Variant, null, null);
				break;
			case "span_multi":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.SpanMultiTermQuery)value.Variant, null, null);
				break;
			case "span_near":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.SpanNearQuery)value.Variant, null, null);
				break;
			case "span_not":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.SpanNotQuery)value.Variant, null, null);
				break;
			case "span_or":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.SpanOrQuery)value.Variant, null, null);
				break;
			case "span_term":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.SpanTermQuery)value.Variant, null, null);
				break;
			case "span_within":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.SpanWithinQuery)value.Variant, null, null);
				break;
			case "sparse_vector":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.SparseVectorQuery)value.Variant, null, null);
				break;
			case "term":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.TermQuery)value.Variant, null, null);
				break;
			case "terms":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.TermsQuery)value.Variant, null, null);
				break;
			case "terms_set":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.TermsSetQuery)value.Variant, null, null);
				break;
			case "text_expansion":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.TextExpansionQuery)value.Variant, null, null);
				break;
			case "type":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.TypeQuery)value.Variant, null, null);
				break;
			case "weighted_tokens":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.WeightedTokensQuery)value.Variant, null, null);
				break;
			case "wildcard":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.WildcardQuery)value.Variant, null, null);
				break;
			case "wrapper":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.WrapperQuery)value.Variant, null, null);
				break;
			default:
				throw new System.Text.Json.JsonException($"Variant '{value.VariantType}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.QueryDsl.Query)}'.");
		}

		writer.WriteEndObject();
	}
}