// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.PrefixQueryConverter))]
public sealed partial class PrefixQuery
{
	[System.Obsolete("The type contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public PrefixQuery(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PrefixQuery(Elastic.Clients.Elasticsearch.Field field, string value)
	{
		Field = field;
		Value = value;
	}
#if NET7_0_OR_GREATER
	public PrefixQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PrefixQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }

	/// <summary>
	/// <para>
	/// Allows ASCII case insensitive matching of the value with the indexed field values when set to <c>true</c>.
	/// Default is <c>false</c> which means the case sensitivity of matching depends on the underlying field’s mapping.
	/// </para>
	/// </summary>
	public bool? CaseInsensitive { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }
	public string? QueryName { get; set; }

	/// <summary>
	/// <para>
	/// Method used to rewrite the query.
	/// </para>
	/// </summary>
	public string? Rewrite { get; set; }

	/// <summary>
	/// <para>
	/// Beginning characters of terms you wish to find in the provided field.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Value { get; set; }
}

public readonly partial struct PrefixQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.PrefixQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PrefixQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.PrefixQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PrefixQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.PrefixQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.PrefixQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.PrefixQuery(Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Allows ASCII case insensitive matching of the value with the indexed field values when set to <c>true</c>.
	/// Default is <c>false</c> which means the case sensitivity of matching depends on the underlying field’s mapping.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor<TDocument> CaseInsensitive(bool? value = true)
	{
		Instance.CaseInsensitive = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Method used to rewrite the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor<TDocument> Rewrite(string? value)
	{
		Instance.Rewrite = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Beginning characters of terms you wish to find in the provided field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor<TDocument> Value(string value)
	{
		Instance.Value = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.PrefixQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.PrefixQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct PrefixQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.PrefixQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PrefixQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.PrefixQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PrefixQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.PrefixQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.PrefixQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.PrefixQuery(Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Allows ASCII case insensitive matching of the value with the indexed field values when set to <c>true</c>.
	/// Default is <c>false</c> which means the case sensitivity of matching depends on the underlying field’s mapping.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor CaseInsensitive(bool? value = true)
	{
		Instance.CaseInsensitive = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Method used to rewrite the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor Rewrite(string? value)
	{
		Instance.Rewrite = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Beginning characters of terms you wish to find in the provided field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor Value(string value)
	{
		Instance.Value = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.PrefixQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.PrefixQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}