// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.ParentIdQueryConverter))]
public sealed partial class ParentIdQuery
{
#if NET7_0_OR_GREATER
	public ParentIdQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public ParentIdQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ParentIdQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }

	/// <summary>
	/// <para>
	/// ID of the parent document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Id? Id { get; set; }

	/// <summary>
	/// <para>
	/// Indicates whether to ignore an unmapped <c>type</c> and not return any documents instead of an error.
	/// </para>
	/// </summary>
	public bool? IgnoreUnmapped { get; set; }
	public string? QueryName { get; set; }

	/// <summary>
	/// <para>
	/// Name of the child relationship mapped for the <c>join</c> field.
	/// </para>
	/// </summary>
	public string? Type { get; set; }
}

public readonly partial struct ParentIdQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.ParentIdQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ParentIdQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.ParentIdQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ParentIdQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.ParentIdQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.ParentIdQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.ParentIdQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.ParentIdQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.ParentIdQuery(Elastic.Clients.Elasticsearch.QueryDsl.ParentIdQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.ParentIdQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// ID of the parent document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.ParentIdQueryDescriptor Id(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether to ignore an unmapped <c>type</c> and not return any documents instead of an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.ParentIdQueryDescriptor IgnoreUnmapped(bool? value = true)
	{
		Instance.IgnoreUnmapped = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.ParentIdQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Name of the child relationship mapped for the <c>join</c> field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.ParentIdQueryDescriptor Type(string? value)
	{
		Instance.Type = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.ParentIdQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.ParentIdQueryDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.QueryDsl.ParentIdQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.ParentIdQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.ParentIdQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}