// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl.Json;

public sealed partial class OperatorConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.QueryDsl.Operator>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAnd = System.Text.Json.JsonEncodedText.Encode("and");
	private static readonly System.Text.Json.JsonEncodedText MemberAnd1 = System.Text.Json.JsonEncodedText.Encode("AND");
	private static readonly System.Text.Json.JsonEncodedText MemberOr = System.Text.Json.JsonEncodedText.Encode("or");
	private static readonly System.Text.Json.JsonEncodedText MemberOr1 = System.Text.Json.JsonEncodedText.Encode("OR");

	public override Elastic.Clients.Elasticsearch.QueryDsl.Operator Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAnd) || reader.ValueTextEquals(MemberAnd1))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.Operator.And;
		}

		if (reader.ValueTextEquals(MemberOr) || reader.ValueTextEquals(MemberOr1))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.Operator.Or;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAnd.Value, System.StringComparison.OrdinalIgnoreCase) || string.Equals(value, MemberAnd1.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.Operator.And;
		}

		if (string.Equals(value, MemberOr.Value, System.StringComparison.OrdinalIgnoreCase) || string.Equals(value, MemberOr1.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.Operator.Or;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.QueryDsl.Operator)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.QueryDsl.Operator value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.QueryDsl.Operator.And:
				writer.WriteStringValue(MemberAnd);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.Operator.Or:
				writer.WriteStringValue(MemberOr);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.QueryDsl.Operator)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.QueryDsl.Operator ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.QueryDsl.Operator value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}