// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.NumericDecayFunctionConverter))]
public sealed partial class NumericDecayFunction : Elastic.Clients.Elasticsearch.QueryDsl.IDecayFunction
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public NumericDecayFunction(Elastic.Clients.Elasticsearch.Field field, Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<double?, double?> placement)
	{
		Field = field;
		Placement = placement;
	}
#if NET7_0_OR_GREATER
	public NumericDecayFunction()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public NumericDecayFunction()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal NumericDecayFunction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Determines how the distance is calculated when a field used for computing the decay contains multiple values.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MultiValueMode? MultiValueMode { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<double?, double?> Placement { get; set; }

	string Elastic.Clients.Elasticsearch.QueryDsl.IDecayFunction.Type => "numeric";
}

public readonly partial struct NumericDecayFunctionDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunction Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public NumericDecayFunctionDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunction instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public NumericDecayFunctionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunctionDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunction instance) => new Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunctionDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunction(Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunctionDescriptor<TDocument> descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunctionDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunctionDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Determines how the distance is calculated when a field used for computing the decay contains multiple values.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunctionDescriptor<TDocument> MultiValueMode(Elastic.Clients.Elasticsearch.QueryDsl.MultiValueMode? value)
	{
		Instance.MultiValueMode = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunctionDescriptor<TDocument> Placement(Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<double?, double?> value)
	{
		Instance.Placement = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunctionDescriptor<TDocument> Placement()
	{
		Instance.Placement = Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDoubleDoubleDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunctionDescriptor<TDocument> Placement(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDoubleDoubleDescriptor>? action)
	{
		Instance.Placement = Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDoubleDoubleDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunction Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunctionDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunctionDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct NumericDecayFunctionDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunction Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public NumericDecayFunctionDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunction instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public NumericDecayFunctionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunctionDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunction instance) => new Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunctionDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunction(Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunctionDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunctionDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunctionDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Determines how the distance is calculated when a field used for computing the decay contains multiple values.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunctionDescriptor MultiValueMode(Elastic.Clients.Elasticsearch.QueryDsl.MultiValueMode? value)
	{
		Instance.MultiValueMode = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunctionDescriptor Placement(Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<double?, double?> value)
	{
		Instance.Placement = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunctionDescriptor Placement()
	{
		Instance.Placement = Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDoubleDoubleDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunctionDescriptor Placement(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDoubleDoubleDescriptor>? action)
	{
		Instance.Placement = Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDoubleDoubleDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunction Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunctionDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunctionDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.NumericDecayFunction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}