// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.NumberRangeQueryConverter))]
public sealed partial class NumberRangeQuery : Elastic.Clients.Elasticsearch.QueryDsl.IRangeQuery
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public NumberRangeQuery(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}
#if NET7_0_OR_GREATER
	public NumberRangeQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal NumberRangeQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Greater than.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Number? Gt { get; set; }

	/// <summary>
	/// <para>
	/// Greater than or equal to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Number? Gte { get; set; }

	/// <summary>
	/// <para>
	/// Less than.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Number? Lt { get; set; }

	/// <summary>
	/// <para>
	/// Less than or equal to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Number? Lte { get; set; }
	public string? QueryName { get; set; }

	/// <summary>
	/// <para>
	/// Indicates how the range query matches values for <c>range</c> fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation? Relation { get; set; }

	string Elastic.Clients.Elasticsearch.QueryDsl.IRangeQuery.Type => "number";
}

public readonly partial struct NumberRangeQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public NumberRangeQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public NumberRangeQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQuery(Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Greater than.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor<TDocument> Gt(Elastic.Clients.Elasticsearch.Number? value)
	{
		Instance.Gt = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Greater than or equal to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor<TDocument> Gte(Elastic.Clients.Elasticsearch.Number? value)
	{
		Instance.Gte = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Less than.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor<TDocument> Lt(Elastic.Clients.Elasticsearch.Number? value)
	{
		Instance.Lt = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Less than or equal to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor<TDocument> Lte(Elastic.Clients.Elasticsearch.Number? value)
	{
		Instance.Lte = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates how the range query matches values for <c>range</c> fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor<TDocument> Relation(Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation? value)
	{
		Instance.Relation = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct NumberRangeQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public NumberRangeQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public NumberRangeQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQuery(Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Greater than.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor Gt(Elastic.Clients.Elasticsearch.Number? value)
	{
		Instance.Gt = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Greater than or equal to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor Gte(Elastic.Clients.Elasticsearch.Number? value)
	{
		Instance.Gte = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Less than.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor Lt(Elastic.Clients.Elasticsearch.Number? value)
	{
		Instance.Lt = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Less than or equal to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor Lte(Elastic.Clients.Elasticsearch.Number? value)
	{
		Instance.Lte = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates how the range query matches values for <c>range</c> fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor Relation(Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation? value)
	{
		Instance.Relation = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}