// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.NestedQueryConverter))]
public sealed partial class NestedQuery
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public NestedQuery(Elastic.Clients.Elasticsearch.Field path, Elastic.Clients.Elasticsearch.QueryDsl.Query query)
	{
		Path = path;
		Query = query;
	}
#if NET7_0_OR_GREATER
	public NestedQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public NestedQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal NestedQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }

	/// <summary>
	/// <para>
	/// Indicates whether to ignore an unmapped path and not return any documents instead of an error.
	/// </para>
	/// </summary>
	public bool? IgnoreUnmapped { get; set; }

	/// <summary>
	/// <para>
	/// If defined, each search hit will contain inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.InnerHits? InnerHits { get; set; }

	/// <summary>
	/// <para>
	/// Path to the nested object you wish to search.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Path { get; set; }

	/// <summary>
	/// <para>
	/// Query you wish to run on nested objects in the path.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.QueryDsl.Query Query { get; set; }
	public string? QueryName { get; set; }

	/// <summary>
	/// <para>
	/// How scores for matching child objects affect the root parent document’s relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.ChildScoreMode? ScoreMode { get; set; }
}

public readonly partial struct NestedQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.NestedQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public NestedQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.NestedQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public NestedQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.NestedQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.NestedQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.NestedQuery(Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether to ignore an unmapped path and not return any documents instead of an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor<TDocument> IgnoreUnmapped(bool? value = true)
	{
		Instance.IgnoreUnmapped = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, each search hit will contain inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor<TDocument> InnerHits(Elastic.Clients.Elasticsearch.Core.Search.InnerHits? value)
	{
		Instance.InnerHits = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, each search hit will contain inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor<TDocument> InnerHits()
	{
		Instance.InnerHits = Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, each search hit will contain inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor<TDocument> InnerHits(System.Action<Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument>>? action)
	{
		Instance.InnerHits = Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Path to the nested object you wish to search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor<TDocument> Path(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Path = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Path to the nested object you wish to search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor<TDocument> Path(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Path = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query you wish to run on nested objects in the path.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor<TDocument> Query(Elastic.Clients.Elasticsearch.QueryDsl.Query value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query you wish to run on nested objects in the path.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor<TDocument> Query(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// How scores for matching child objects affect the root parent document’s relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor<TDocument> ScoreMode(Elastic.Clients.Elasticsearch.QueryDsl.ChildScoreMode? value)
	{
		Instance.ScoreMode = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.NestedQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.NestedQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct NestedQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.NestedQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public NestedQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.NestedQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public NestedQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.NestedQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.NestedQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.NestedQuery(Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether to ignore an unmapped path and not return any documents instead of an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor IgnoreUnmapped(bool? value = true)
	{
		Instance.IgnoreUnmapped = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, each search hit will contain inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor InnerHits(Elastic.Clients.Elasticsearch.Core.Search.InnerHits? value)
	{
		Instance.InnerHits = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, each search hit will contain inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor InnerHits()
	{
		Instance.InnerHits = Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, each search hit will contain inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor InnerHits(System.Action<Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor>? action)
	{
		Instance.InnerHits = Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, each search hit will contain inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor InnerHits<T>(System.Action<Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<T>>? action)
	{
		Instance.InnerHits = Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Path to the nested object you wish to search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor Path(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Path = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Path to the nested object you wish to search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor Path<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Path = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query you wish to run on nested objects in the path.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor Query(Elastic.Clients.Elasticsearch.QueryDsl.Query value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query you wish to run on nested objects in the path.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor Query(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Query you wish to run on nested objects in the path.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor Query<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// How scores for matching child objects affect the root parent document’s relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor ScoreMode(Elastic.Clients.Elasticsearch.QueryDsl.ChildScoreMode? value)
	{
		Instance.ScoreMode = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.NestedQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.NestedQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.NestedQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}