// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.MoreLikeThisQueryConverter))]
public sealed partial class MoreLikeThisQuery
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MoreLikeThisQuery(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Like> like)
	{
		Like = like;
	}
#if NET7_0_OR_GREATER
	public MoreLikeThisQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public MoreLikeThisQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal MoreLikeThisQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The analyzer that is used to analyze the free form text.
	/// Defaults to the analyzer associated with the first field in fields.
	/// </para>
	/// </summary>
	public string? Analyzer { get; set; }

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }

	/// <summary>
	/// <para>
	/// Each term in the formed query could be further boosted by their tf-idf score.
	/// This sets the boost factor to use when using this feature.
	/// Defaults to deactivated (0).
	/// </para>
	/// </summary>
	public double? BoostTerms { get; set; }

	/// <summary>
	/// <para>
	/// Controls whether the query should fail (throw an exception) if any of the specified fields are not of the supported types (<c>text</c> or <c>keyword</c>).
	/// </para>
	/// </summary>
	public bool? FailOnUnsupportedField { get; set; }

	/// <summary>
	/// <para>
	/// A list of fields to fetch and analyze the text from.
	/// Defaults to the <c>index.query.default_field</c> index setting, which has a default value of <c>*</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? Fields { get; set; }

	/// <summary>
	/// <para>
	/// Specifies whether the input documents should also be included in the search results returned.
	/// </para>
	/// </summary>
	public bool? Include { get; set; }

	/// <summary>
	/// <para>
	/// Specifies free form text and/or a single or multiple documents for which you want to find similar documents.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Like> Like { get; set; }

	/// <summary>
	/// <para>
	/// The maximum document frequency above which the terms are ignored from the input document.
	/// </para>
	/// </summary>
	public int? MaxDocFreq { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of query terms that can be selected.
	/// </para>
	/// </summary>
	public int? MaxQueryTerms { get; set; }

	/// <summary>
	/// <para>
	/// The maximum word length above which the terms are ignored.
	/// Defaults to unbounded (<c>0</c>).
	/// </para>
	/// </summary>
	public int? MaxWordLength { get; set; }

	/// <summary>
	/// <para>
	/// The minimum document frequency below which the terms are ignored from the input document.
	/// </para>
	/// </summary>
	public int? MinDocFreq { get; set; }

	/// <summary>
	/// <para>
	/// After the disjunctive query has been formed, this parameter controls the number of terms that must match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MinimumShouldMatch? MinimumShouldMatch { get; set; }

	/// <summary>
	/// <para>
	/// The minimum term frequency below which the terms are ignored from the input document.
	/// </para>
	/// </summary>
	public int? MinTermFreq { get; set; }

	/// <summary>
	/// <para>
	/// The minimum word length below which the terms are ignored.
	/// </para>
	/// </summary>
	public int? MinWordLength { get; set; }
	public string? QueryName { get; set; }
	public Elastic.Clients.Elasticsearch.Routing? Routing { get; set; }

	/// <summary>
	/// <para>
	/// An array of stop words.
	/// Any word in this set is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Union<Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage, System.Collections.Generic.ICollection<string>>? StopWords { get; set; }

	/// <summary>
	/// <para>
	/// Used in combination with <c>like</c> to exclude documents that match a set of terms.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Like>? Unlike { get; set; }
	public long? Version { get; set; }
	public Elastic.Clients.Elasticsearch.VersionType? VersionType { get; set; }
}

public readonly partial struct MoreLikeThisQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MoreLikeThisQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MoreLikeThisQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQuery(Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The analyzer that is used to analyze the free form text.
	/// Defaults to the analyzer associated with the first field in fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument> Analyzer(string? value)
	{
		Instance.Analyzer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Each term in the formed query could be further boosted by their tf-idf score.
	/// This sets the boost factor to use when using this feature.
	/// Defaults to deactivated (0).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument> BoostTerms(double? value)
	{
		Instance.BoostTerms = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Controls whether the query should fail (throw an exception) if any of the specified fields are not of the supported types (<c>text</c> or <c>keyword</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument> FailOnUnsupportedField(bool? value = true)
	{
		Instance.FailOnUnsupportedField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of fields to fetch and analyze the text from.
	/// Defaults to the <c>index.query.default_field</c> index setting, which has a default value of <c>*</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument> Fields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of fields to fetch and analyze the text from.
	/// Defaults to the <c>index.query.default_field</c> index setting, which has a default value of <c>*</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument> Fields(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies whether the input documents should also be included in the search results returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument> Include(bool? value = true)
	{
		Instance.Include = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies free form text and/or a single or multiple documents for which you want to find similar documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument> Like(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Like> value)
	{
		Instance.Like = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies free form text and/or a single or multiple documents for which you want to find similar documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument> Like(params Elastic.Clients.Elasticsearch.QueryDsl.Like[] values)
	{
		Instance.Like = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies free form text and/or a single or multiple documents for which you want to find similar documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument> Like(params System.Func<Elastic.Clients.Elasticsearch.QueryDsl.LikeFactory<TDocument>, Elastic.Clients.Elasticsearch.QueryDsl.Like>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Like>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.LikeFactory<TDocument>.Build(action));
		}

		Instance.Like = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum document frequency above which the terms are ignored from the input document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument> MaxDocFreq(int? value)
	{
		Instance.MaxDocFreq = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of query terms that can be selected.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument> MaxQueryTerms(int? value)
	{
		Instance.MaxQueryTerms = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum word length above which the terms are ignored.
	/// Defaults to unbounded (<c>0</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument> MaxWordLength(int? value)
	{
		Instance.MaxWordLength = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum document frequency below which the terms are ignored from the input document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument> MinDocFreq(int? value)
	{
		Instance.MinDocFreq = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// After the disjunctive query has been formed, this parameter controls the number of terms that must match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument> MinimumShouldMatch(Elastic.Clients.Elasticsearch.MinimumShouldMatch? value)
	{
		Instance.MinimumShouldMatch = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum term frequency below which the terms are ignored from the input document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument> MinTermFreq(int? value)
	{
		Instance.MinTermFreq = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum word length below which the terms are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument> MinWordLength(int? value)
	{
		Instance.MinWordLength = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument> Routing(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.Routing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of stop words.
	/// Any word in this set is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument> StopWords(Elastic.Clients.Elasticsearch.Union<Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage, System.Collections.Generic.ICollection<string>>? value)
	{
		Instance.StopWords = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Used in combination with <c>like</c> to exclude documents that match a set of terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument> Unlike(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Like>? value)
	{
		Instance.Unlike = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Used in combination with <c>like</c> to exclude documents that match a set of terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument> Unlike(params Elastic.Clients.Elasticsearch.QueryDsl.Like[] values)
	{
		Instance.Unlike = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Used in combination with <c>like</c> to exclude documents that match a set of terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument> Unlike(params System.Func<Elastic.Clients.Elasticsearch.QueryDsl.LikeFactory<TDocument>, Elastic.Clients.Elasticsearch.QueryDsl.Like>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Like>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.LikeFactory<TDocument>.Build(action));
		}

		Instance.Unlike = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument> Version(long? value)
	{
		Instance.Version = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument> VersionType(Elastic.Clients.Elasticsearch.VersionType? value)
	{
		Instance.VersionType = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct MoreLikeThisQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MoreLikeThisQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MoreLikeThisQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQuery(Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The analyzer that is used to analyze the free form text.
	/// Defaults to the analyzer associated with the first field in fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor Analyzer(string? value)
	{
		Instance.Analyzer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Each term in the formed query could be further boosted by their tf-idf score.
	/// This sets the boost factor to use when using this feature.
	/// Defaults to deactivated (0).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor BoostTerms(double? value)
	{
		Instance.BoostTerms = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Controls whether the query should fail (throw an exception) if any of the specified fields are not of the supported types (<c>text</c> or <c>keyword</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor FailOnUnsupportedField(bool? value = true)
	{
		Instance.FailOnUnsupportedField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of fields to fetch and analyze the text from.
	/// Defaults to the <c>index.query.default_field</c> index setting, which has a default value of <c>*</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor Fields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of fields to fetch and analyze the text from.
	/// Defaults to the <c>index.query.default_field</c> index setting, which has a default value of <c>*</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor Fields<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies whether the input documents should also be included in the search results returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor Include(bool? value = true)
	{
		Instance.Include = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies free form text and/or a single or multiple documents for which you want to find similar documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor Like(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Like> value)
	{
		Instance.Like = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies free form text and/or a single or multiple documents for which you want to find similar documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor Like(params Elastic.Clients.Elasticsearch.QueryDsl.Like[] values)
	{
		Instance.Like = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies free form text and/or a single or multiple documents for which you want to find similar documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor Like(params System.Func<Elastic.Clients.Elasticsearch.QueryDsl.LikeFactory, Elastic.Clients.Elasticsearch.QueryDsl.Like>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Like>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.LikeFactory.Build(action));
		}

		Instance.Like = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies free form text and/or a single or multiple documents for which you want to find similar documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor Like<T>(params System.Func<Elastic.Clients.Elasticsearch.QueryDsl.LikeFactory<T>, Elastic.Clients.Elasticsearch.QueryDsl.Like>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Like>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.LikeFactory<T>.Build(action));
		}

		Instance.Like = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum document frequency above which the terms are ignored from the input document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor MaxDocFreq(int? value)
	{
		Instance.MaxDocFreq = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of query terms that can be selected.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor MaxQueryTerms(int? value)
	{
		Instance.MaxQueryTerms = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum word length above which the terms are ignored.
	/// Defaults to unbounded (<c>0</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor MaxWordLength(int? value)
	{
		Instance.MaxWordLength = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum document frequency below which the terms are ignored from the input document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor MinDocFreq(int? value)
	{
		Instance.MinDocFreq = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// After the disjunctive query has been formed, this parameter controls the number of terms that must match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor MinimumShouldMatch(Elastic.Clients.Elasticsearch.MinimumShouldMatch? value)
	{
		Instance.MinimumShouldMatch = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum term frequency below which the terms are ignored from the input document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor MinTermFreq(int? value)
	{
		Instance.MinTermFreq = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum word length below which the terms are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor MinWordLength(int? value)
	{
		Instance.MinWordLength = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor Routing(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.Routing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of stop words.
	/// Any word in this set is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor StopWords(Elastic.Clients.Elasticsearch.Union<Elastic.Clients.Elasticsearch.Analysis.StopWordLanguage, System.Collections.Generic.ICollection<string>>? value)
	{
		Instance.StopWords = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Used in combination with <c>like</c> to exclude documents that match a set of terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor Unlike(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Like>? value)
	{
		Instance.Unlike = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Used in combination with <c>like</c> to exclude documents that match a set of terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor Unlike(params Elastic.Clients.Elasticsearch.QueryDsl.Like[] values)
	{
		Instance.Unlike = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Used in combination with <c>like</c> to exclude documents that match a set of terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor Unlike(params System.Func<Elastic.Clients.Elasticsearch.QueryDsl.LikeFactory, Elastic.Clients.Elasticsearch.QueryDsl.Like>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Like>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.LikeFactory.Build(action));
		}

		Instance.Unlike = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Used in combination with <c>like</c> to exclude documents that match a set of terms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor Unlike<T>(params System.Func<Elastic.Clients.Elasticsearch.QueryDsl.LikeFactory<T>, Elastic.Clients.Elasticsearch.QueryDsl.Like>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Like>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.LikeFactory<T>.Build(action));
		}

		Instance.Unlike = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor Version(long? value)
	{
		Instance.Version = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor VersionType(Elastic.Clients.Elasticsearch.VersionType? value)
	{
		Instance.VersionType = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.MoreLikeThisQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}