// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.MatchPhraseQueryConverter))]
public sealed partial class MatchPhraseQuery
{
	[System.Obsolete("The type contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public MatchPhraseQuery(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MatchPhraseQuery(Elastic.Clients.Elasticsearch.Field field, string query)
	{
		Field = field;
		Query = query;
	}
#if NET7_0_OR_GREATER
	public MatchPhraseQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal MatchPhraseQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Analyzer used to convert the text in the query value into tokens.
	/// </para>
	/// </summary>
	public string? Analyzer { get; set; }

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Query terms that are analyzed and turned into a phrase query.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Query { get; set; }
	public string? QueryName { get; set; }

	/// <summary>
	/// <para>
	/// Maximum number of positions allowed between matching tokens.
	/// </para>
	/// </summary>
	public int? Slop { get; set; }

	/// <summary>
	/// <para>
	/// Indicates whether no documents are returned if the <c>analyzer</c> removes all tokens, such as when using a <c>stop</c> filter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.ZeroTermsQuery? ZeroTermsQuery { get; set; }
}

public readonly partial struct MatchPhraseQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MatchPhraseQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MatchPhraseQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQuery(Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Analyzer used to convert the text in the query value into tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQueryDescriptor<TDocument> Analyzer(string? value)
	{
		Instance.Analyzer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQueryDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQueryDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query terms that are analyzed and turned into a phrase query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQueryDescriptor<TDocument> Query(string value)
	{
		Instance.Query = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of positions allowed between matching tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQueryDescriptor<TDocument> Slop(int? value)
	{
		Instance.Slop = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether no documents are returned if the <c>analyzer</c> removes all tokens, such as when using a <c>stop</c> filter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQueryDescriptor<TDocument> ZeroTermsQuery(Elastic.Clients.Elasticsearch.QueryDsl.ZeroTermsQuery? value)
	{
		Instance.ZeroTermsQuery = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct MatchPhraseQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MatchPhraseQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MatchPhraseQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQuery(Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Analyzer used to convert the text in the query value into tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQueryDescriptor Analyzer(string? value)
	{
		Instance.Analyzer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQueryDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQueryDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query terms that are analyzed and turned into a phrase query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQueryDescriptor Query(string value)
	{
		Instance.Query = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of positions allowed between matching tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQueryDescriptor Slop(int? value)
	{
		Instance.Slop = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether no documents are returned if the <c>analyzer</c> removes all tokens, such as when using a <c>stop</c> filter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQueryDescriptor ZeroTermsQuery(Elastic.Clients.Elasticsearch.QueryDsl.ZeroTermsQuery? value)
	{
		Instance.ZeroTermsQuery = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.MatchPhraseQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}