// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.MatchBoolPrefixQueryConverter))]
public sealed partial class MatchBoolPrefixQuery
{
	[System.Obsolete("The type contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public MatchBoolPrefixQuery(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MatchBoolPrefixQuery(Elastic.Clients.Elasticsearch.Field field, string query)
	{
		Field = field;
		Query = query;
	}
#if NET7_0_OR_GREATER
	public MatchBoolPrefixQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal MatchBoolPrefixQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Analyzer used to convert the text in the query value into tokens.
	/// </para>
	/// </summary>
	public string? Analyzer { get; set; }

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Maximum edit distance allowed for matching.
	/// Can be applied to the term subqueries constructed for all terms but the final term.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fuzziness? Fuzziness { get; set; }

	/// <summary>
	/// <para>
	/// Method used to rewrite the query.
	/// Can be applied to the term subqueries constructed for all terms but the final term.
	/// </para>
	/// </summary>
	public string? FuzzyRewrite { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, edits for fuzzy matching include transpositions of two adjacent characters (for example, <c>ab</c> to <c>ba</c>).
	/// Can be applied to the term subqueries constructed for all terms but the final term.
	/// </para>
	/// </summary>
	public bool? FuzzyTranspositions { get; set; }

	/// <summary>
	/// <para>
	/// Maximum number of terms to which the query will expand.
	/// Can be applied to the term subqueries constructed for all terms but the final term.
	/// </para>
	/// </summary>
	public int? MaxExpansions { get; set; }

	/// <summary>
	/// <para>
	/// Minimum number of clauses that must match for a document to be returned.
	/// Applied to the constructed bool query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MinimumShouldMatch? MinimumShouldMatch { get; set; }

	/// <summary>
	/// <para>
	/// Boolean logic used to interpret text in the query value.
	/// Applied to the constructed bool query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.Operator? Operator { get; set; }

	/// <summary>
	/// <para>
	/// Number of beginning characters left unchanged for fuzzy matching.
	/// Can be applied to the term subqueries constructed for all terms but the final term.
	/// </para>
	/// </summary>
	public int? PrefixLength { get; set; }

	/// <summary>
	/// <para>
	/// Terms you wish to find in the provided field.
	/// The last term is used in a prefix query.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Query { get; set; }
	public string? QueryName { get; set; }
}

public readonly partial struct MatchBoolPrefixQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MatchBoolPrefixQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MatchBoolPrefixQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQuery(Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Analyzer used to convert the text in the query value into tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor<TDocument> Analyzer(string? value)
	{
		Instance.Analyzer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum edit distance allowed for matching.
	/// Can be applied to the term subqueries constructed for all terms but the final term.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor<TDocument> Fuzziness(Elastic.Clients.Elasticsearch.Fuzziness? value)
	{
		Instance.Fuzziness = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum edit distance allowed for matching.
	/// Can be applied to the term subqueries constructed for all terms but the final term.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor<TDocument> Fuzziness(System.Func<Elastic.Clients.Elasticsearch.FuzzinessFactory, Elastic.Clients.Elasticsearch.Fuzziness> action)
	{
		Instance.Fuzziness = Elastic.Clients.Elasticsearch.FuzzinessFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Method used to rewrite the query.
	/// Can be applied to the term subqueries constructed for all terms but the final term.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor<TDocument> FuzzyRewrite(string? value)
	{
		Instance.FuzzyRewrite = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, edits for fuzzy matching include transpositions of two adjacent characters (for example, <c>ab</c> to <c>ba</c>).
	/// Can be applied to the term subqueries constructed for all terms but the final term.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor<TDocument> FuzzyTranspositions(bool? value = true)
	{
		Instance.FuzzyTranspositions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of terms to which the query will expand.
	/// Can be applied to the term subqueries constructed for all terms but the final term.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor<TDocument> MaxExpansions(int? value)
	{
		Instance.MaxExpansions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum number of clauses that must match for a document to be returned.
	/// Applied to the constructed bool query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor<TDocument> MinimumShouldMatch(Elastic.Clients.Elasticsearch.MinimumShouldMatch? value)
	{
		Instance.MinimumShouldMatch = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Boolean logic used to interpret text in the query value.
	/// Applied to the constructed bool query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor<TDocument> Operator(Elastic.Clients.Elasticsearch.QueryDsl.Operator? value)
	{
		Instance.Operator = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of beginning characters left unchanged for fuzzy matching.
	/// Can be applied to the term subqueries constructed for all terms but the final term.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor<TDocument> PrefixLength(int? value)
	{
		Instance.PrefixLength = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Terms you wish to find in the provided field.
	/// The last term is used in a prefix query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor<TDocument> Query(string value)
	{
		Instance.Query = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct MatchBoolPrefixQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MatchBoolPrefixQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MatchBoolPrefixQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQuery(Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Analyzer used to convert the text in the query value into tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor Analyzer(string? value)
	{
		Instance.Analyzer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum edit distance allowed for matching.
	/// Can be applied to the term subqueries constructed for all terms but the final term.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor Fuzziness(Elastic.Clients.Elasticsearch.Fuzziness? value)
	{
		Instance.Fuzziness = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum edit distance allowed for matching.
	/// Can be applied to the term subqueries constructed for all terms but the final term.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor Fuzziness(System.Func<Elastic.Clients.Elasticsearch.FuzzinessFactory, Elastic.Clients.Elasticsearch.Fuzziness> action)
	{
		Instance.Fuzziness = Elastic.Clients.Elasticsearch.FuzzinessFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Method used to rewrite the query.
	/// Can be applied to the term subqueries constructed for all terms but the final term.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor FuzzyRewrite(string? value)
	{
		Instance.FuzzyRewrite = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, edits for fuzzy matching include transpositions of two adjacent characters (for example, <c>ab</c> to <c>ba</c>).
	/// Can be applied to the term subqueries constructed for all terms but the final term.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor FuzzyTranspositions(bool? value = true)
	{
		Instance.FuzzyTranspositions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of terms to which the query will expand.
	/// Can be applied to the term subqueries constructed for all terms but the final term.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor MaxExpansions(int? value)
	{
		Instance.MaxExpansions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum number of clauses that must match for a document to be returned.
	/// Applied to the constructed bool query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor MinimumShouldMatch(Elastic.Clients.Elasticsearch.MinimumShouldMatch? value)
	{
		Instance.MinimumShouldMatch = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Boolean logic used to interpret text in the query value.
	/// Applied to the constructed bool query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor Operator(Elastic.Clients.Elasticsearch.QueryDsl.Operator? value)
	{
		Instance.Operator = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of beginning characters left unchanged for fuzzy matching.
	/// Can be applied to the term subqueries constructed for all terms but the final term.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor PrefixLength(int? value)
	{
		Instance.PrefixLength = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Terms you wish to find in the provided field.
	/// The last term is used in a prefix query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor Query(string value)
	{
		Instance.Query = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.MatchBoolPrefixQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}