// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

/// <summary>
/// <para>
/// Text that we want similar documents for or a lookup to a document's field for the text.
/// </para>
/// <para><see href="https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-mlt-query#_document_input_parameters">Learn more about this API in the Elasticsearch documentation.</see></para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.LikeConverter))]
public sealed partial class Like : Elastic.Clients.Elasticsearch.Union<string, Elastic.Clients.Elasticsearch.QueryDsl.LikeDocument>
{
	public Like(string value) : base(value)
	{
	}

	public Like(Elastic.Clients.Elasticsearch.QueryDsl.LikeDocument value) : base(value)
	{
	}

	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.Like(string value) => new Elastic.Clients.Elasticsearch.QueryDsl.Like(value);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.Like(Elastic.Clients.Elasticsearch.QueryDsl.LikeDocument value) => new Elastic.Clients.Elasticsearch.QueryDsl.Like(value);
}

public readonly partial struct LikeFactory<TDocument>
{
	public Elastic.Clients.Elasticsearch.QueryDsl.Like Text(string value)
	{
		return new Elastic.Clients.Elasticsearch.QueryDsl.Like(value);
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.Like Document(Elastic.Clients.Elasticsearch.QueryDsl.LikeDocument value)
	{
		return new Elastic.Clients.Elasticsearch.QueryDsl.Like(value);
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.Like Document()
	{
		return new Elastic.Clients.Elasticsearch.QueryDsl.Like(Elastic.Clients.Elasticsearch.QueryDsl.LikeDocumentDescriptor<TDocument>.Build(null));
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.Like Document(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.LikeDocumentDescriptor<TDocument>>? action)
	{
		return new Elastic.Clients.Elasticsearch.QueryDsl.Like(Elastic.Clients.Elasticsearch.QueryDsl.LikeDocumentDescriptor<TDocument>.Build(action));
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.Like Build(System.Func<Elastic.Clients.Elasticsearch.QueryDsl.LikeFactory<TDocument>, Elastic.Clients.Elasticsearch.QueryDsl.Like> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.LikeFactory<TDocument>();
		return action.Invoke(builder);
	}
}

public readonly partial struct LikeFactory
{
	public Elastic.Clients.Elasticsearch.QueryDsl.Like Text(string value)
	{
		return new Elastic.Clients.Elasticsearch.QueryDsl.Like(value);
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.Like Document(Elastic.Clients.Elasticsearch.QueryDsl.LikeDocument value)
	{
		return new Elastic.Clients.Elasticsearch.QueryDsl.Like(value);
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.Like Document()
	{
		return new Elastic.Clients.Elasticsearch.QueryDsl.Like(Elastic.Clients.Elasticsearch.QueryDsl.LikeDocumentDescriptor.Build(null));
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.Like Document(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.LikeDocumentDescriptor>? action)
	{
		return new Elastic.Clients.Elasticsearch.QueryDsl.Like(Elastic.Clients.Elasticsearch.QueryDsl.LikeDocumentDescriptor.Build(action));
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.Like Document<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.LikeDocumentDescriptor<T>>? action)
	{
		return new Elastic.Clients.Elasticsearch.QueryDsl.Like(Elastic.Clients.Elasticsearch.QueryDsl.LikeDocumentDescriptor<T>.Build(action));
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.Like Build(System.Func<Elastic.Clients.Elasticsearch.QueryDsl.LikeFactory, Elastic.Clients.Elasticsearch.QueryDsl.Like> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.LikeFactory();
		return action.Invoke(builder);
	}
}