// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.IntervalsPrefixConverter))]
public sealed partial class IntervalsPrefix
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IntervalsPrefix(string prefix)
	{
		Prefix = prefix;
	}
#if NET7_0_OR_GREATER
	public IntervalsPrefix()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public IntervalsPrefix()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal IntervalsPrefix(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Analyzer used to analyze the <c>prefix</c>.
	/// </para>
	/// </summary>
	public string? Analyzer { get; set; }

	/// <summary>
	/// <para>
	/// Beginning characters of terms you wish to find in the top-level field.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Prefix { get; set; }

	/// <summary>
	/// <para>
	/// If specified, match intervals from this field rather than the top-level field.
	/// The <c>prefix</c> is normalized using the search analyzer from this field, unless <c>analyzer</c> is specified separately.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? UseField { get; set; }
}

public readonly partial struct IntervalsPrefixDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefix Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IntervalsPrefixDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefix instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IntervalsPrefixDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefix(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefixDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefix instance) => new Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefixDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefix(Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefixDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Analyzer used to analyze the <c>prefix</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefixDescriptor<TDocument> Analyzer(string? value)
	{
		Instance.Analyzer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Beginning characters of terms you wish to find in the top-level field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefixDescriptor<TDocument> Prefix(string value)
	{
		Instance.Prefix = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If specified, match intervals from this field rather than the top-level field.
	/// The <c>prefix</c> is normalized using the search analyzer from this field, unless <c>analyzer</c> is specified separately.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefixDescriptor<TDocument> UseField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.UseField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If specified, match intervals from this field rather than the top-level field.
	/// The <c>prefix</c> is normalized using the search analyzer from this field, unless <c>analyzer</c> is specified separately.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefixDescriptor<TDocument> UseField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.UseField = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefix Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefixDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefixDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefix(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct IntervalsPrefixDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefix Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IntervalsPrefixDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefix instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IntervalsPrefixDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefix(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefixDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefix instance) => new Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefixDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefix(Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefixDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Analyzer used to analyze the <c>prefix</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefixDescriptor Analyzer(string? value)
	{
		Instance.Analyzer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Beginning characters of terms you wish to find in the top-level field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefixDescriptor Prefix(string value)
	{
		Instance.Prefix = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If specified, match intervals from this field rather than the top-level field.
	/// The <c>prefix</c> is normalized using the search analyzer from this field, unless <c>analyzer</c> is specified separately.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefixDescriptor UseField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.UseField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If specified, match intervals from this field rather than the top-level field.
	/// The <c>prefix</c> is normalized using the search analyzer from this field, unless <c>analyzer</c> is specified separately.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefixDescriptor UseField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.UseField = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefix Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefixDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefixDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.IntervalsPrefix(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}