// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl.Json;

public sealed partial class IntervalsFilterConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.QueryDsl.IntervalsFilter>
{
	private static readonly System.Text.Json.JsonEncodedText VariantAfter = System.Text.Json.JsonEncodedText.Encode("after");
	private static readonly System.Text.Json.JsonEncodedText VariantBefore = System.Text.Json.JsonEncodedText.Encode("before");
	private static readonly System.Text.Json.JsonEncodedText VariantContainedBy = System.Text.Json.JsonEncodedText.Encode("contained_by");
	private static readonly System.Text.Json.JsonEncodedText VariantContaining = System.Text.Json.JsonEncodedText.Encode("containing");
	private static readonly System.Text.Json.JsonEncodedText VariantNotContainedBy = System.Text.Json.JsonEncodedText.Encode("not_contained_by");
	private static readonly System.Text.Json.JsonEncodedText VariantNotContaining = System.Text.Json.JsonEncodedText.Encode("not_containing");
	private static readonly System.Text.Json.JsonEncodedText VariantNotOverlapping = System.Text.Json.JsonEncodedText.Encode("not_overlapping");
	private static readonly System.Text.Json.JsonEncodedText VariantOverlapping = System.Text.Json.JsonEncodedText.Encode("overlapping");
	private static readonly System.Text.Json.JsonEncodedText VariantScript = System.Text.Json.JsonEncodedText.Encode("script");

	public override Elastic.Clients.Elasticsearch.QueryDsl.IntervalsFilter Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		string? variantType = null;
		object? variant = null;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (reader.ValueTextEquals(VariantAfter))
			{
				variantType = VariantAfter.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.Intervals>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantBefore))
			{
				variantType = VariantBefore.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.Intervals>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantContainedBy))
			{
				variantType = VariantContainedBy.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.Intervals>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantContaining))
			{
				variantType = VariantContaining.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.Intervals>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantNotContainedBy))
			{
				variantType = VariantNotContainedBy.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.Intervals>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantNotContaining))
			{
				variantType = VariantNotContaining.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.Intervals>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantNotOverlapping))
			{
				variantType = VariantNotOverlapping.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.Intervals>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantOverlapping))
			{
				variantType = VariantOverlapping.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.Intervals>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantScript))
			{
				variantType = VariantScript.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Script>(options, null);
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.QueryDsl.IntervalsFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			VariantType = variantType,
			Variant = variant
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.QueryDsl.IntervalsFilter value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		switch (value.VariantType)
		{
			case null:
				break;
			case "after":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.Intervals)value.Variant, null, null);
				break;
			case "before":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.Intervals)value.Variant, null, null);
				break;
			case "contained_by":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.Intervals)value.Variant, null, null);
				break;
			case "containing":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.Intervals)value.Variant, null, null);
				break;
			case "not_contained_by":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.Intervals)value.Variant, null, null);
				break;
			case "not_containing":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.Intervals)value.Variant, null, null);
				break;
			case "not_overlapping":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.Intervals)value.Variant, null, null);
				break;
			case "overlapping":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.Intervals)value.Variant, null, null);
				break;
			case "script":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Script)value.Variant, null, null);
				break;
			default:
				throw new System.Text.Json.JsonException($"Variant '{value.VariantType}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.QueryDsl.IntervalsFilter)}'.");
		}

		writer.WriteEndObject();
	}
}