// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.IntervalsAllOfConverter))]
public sealed partial class IntervalsAllOf
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IntervalsAllOf(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Intervals> intervals)
	{
		Intervals = intervals;
	}
#if NET7_0_OR_GREATER
	public IntervalsAllOf()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public IntervalsAllOf()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal IntervalsAllOf(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Rule used to filter returned intervals.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IntervalsFilter? Filter { get; set; }

	/// <summary>
	/// <para>
	/// An array of rules to combine. All rules must produce a match in a document for the overall source to match.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Intervals> Intervals { get; set; }

	/// <summary>
	/// <para>
	/// Maximum number of positions between the matching terms.
	/// Intervals produced by the rules further apart than this are not considered matches.
	/// </para>
	/// </summary>
	public int? MaxGaps { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, intervals produced by the rules should appear in the order in which they are specified.
	/// </para>
	/// </summary>
	public bool? Ordered { get; set; }
}

public readonly partial struct IntervalsAllOfDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOf Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IntervalsAllOfDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOf instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IntervalsAllOfDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOf(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOfDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOf instance) => new Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOfDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOf(Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOfDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Rule used to filter returned intervals.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOfDescriptor<TDocument> Filter(Elastic.Clients.Elasticsearch.QueryDsl.IntervalsFilter? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Rule used to filter returned intervals.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOfDescriptor<TDocument> Filter(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.IntervalsFilterDescriptor<TDocument>> action)
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.QueryDsl.IntervalsFilterDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of rules to combine. All rules must produce a match in a document for the overall source to match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOfDescriptor<TDocument> Intervals(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Intervals> value)
	{
		Instance.Intervals = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of rules to combine. All rules must produce a match in a document for the overall source to match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOfDescriptor<TDocument> Intervals(params Elastic.Clients.Elasticsearch.QueryDsl.Intervals[] values)
	{
		Instance.Intervals = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of rules to combine. All rules must produce a match in a document for the overall source to match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOfDescriptor<TDocument> Intervals(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.IntervalsDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Intervals>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.IntervalsDescriptor<TDocument>.Build(action));
		}

		Instance.Intervals = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of positions between the matching terms.
	/// Intervals produced by the rules further apart than this are not considered matches.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOfDescriptor<TDocument> MaxGaps(int? value)
	{
		Instance.MaxGaps = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, intervals produced by the rules should appear in the order in which they are specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOfDescriptor<TDocument> Ordered(bool? value = true)
	{
		Instance.Ordered = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOf Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOfDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOfDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOf(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct IntervalsAllOfDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOf Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IntervalsAllOfDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOf instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IntervalsAllOfDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOf(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOfDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOf instance) => new Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOfDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOf(Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOfDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Rule used to filter returned intervals.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOfDescriptor Filter(Elastic.Clients.Elasticsearch.QueryDsl.IntervalsFilter? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Rule used to filter returned intervals.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOfDescriptor Filter(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.IntervalsFilterDescriptor> action)
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.QueryDsl.IntervalsFilterDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Rule used to filter returned intervals.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOfDescriptor Filter<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.IntervalsFilterDescriptor<T>> action)
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.QueryDsl.IntervalsFilterDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of rules to combine. All rules must produce a match in a document for the overall source to match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOfDescriptor Intervals(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Intervals> value)
	{
		Instance.Intervals = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of rules to combine. All rules must produce a match in a document for the overall source to match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOfDescriptor Intervals(params Elastic.Clients.Elasticsearch.QueryDsl.Intervals[] values)
	{
		Instance.Intervals = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of rules to combine. All rules must produce a match in a document for the overall source to match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOfDescriptor Intervals(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.IntervalsDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Intervals>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.IntervalsDescriptor.Build(action));
		}

		Instance.Intervals = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of rules to combine. All rules must produce a match in a document for the overall source to match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOfDescriptor Intervals<T>(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.IntervalsDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Intervals>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.IntervalsDescriptor<T>.Build(action));
		}

		Instance.Intervals = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of positions between the matching terms.
	/// Intervals produced by the rules further apart than this are not considered matches.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOfDescriptor MaxGaps(int? value)
	{
		Instance.MaxGaps = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, intervals produced by the rules should appear in the order in which they are specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOfDescriptor Ordered(bool? value = true)
	{
		Instance.Ordered = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOf Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOfDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOfDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.IntervalsAllOf(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}