// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.HasParentQueryConverter))]
public sealed partial class HasParentQuery
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public HasParentQuery(string parentType, Elastic.Clients.Elasticsearch.QueryDsl.Query query)
	{
		ParentType = parentType;
		Query = query;
	}
#if NET7_0_OR_GREATER
	public HasParentQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public HasParentQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal HasParentQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }

	/// <summary>
	/// <para>
	/// Indicates whether to ignore an unmapped <c>parent_type</c> and not return any documents instead of an error.
	/// You can use this parameter to query multiple indices that may not contain the <c>parent_type</c>.
	/// </para>
	/// </summary>
	public bool? IgnoreUnmapped { get; set; }

	/// <summary>
	/// <para>
	/// If defined, each search hit will contain inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.InnerHits? InnerHits { get; set; }

	/// <summary>
	/// <para>
	/// Name of the parent relationship mapped for the <c>join</c> field.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ParentType { get; set; }

	/// <summary>
	/// <para>
	/// Query you wish to run on parent documents of the <c>parent_type</c> field.
	/// If a parent document matches the search, the query returns its child documents.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.QueryDsl.Query Query { get; set; }
	public string? QueryName { get; set; }

	/// <summary>
	/// <para>
	/// Indicates whether the relevance score of a matching parent document is aggregated into its child documents.
	/// </para>
	/// </summary>
	public bool? Score { get; set; }
}

public readonly partial struct HasParentQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.HasParentQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public HasParentQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.HasParentQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public HasParentQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.HasParentQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.HasParentQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.HasParentQuery(Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether to ignore an unmapped <c>parent_type</c> and not return any documents instead of an error.
	/// You can use this parameter to query multiple indices that may not contain the <c>parent_type</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor<TDocument> IgnoreUnmapped(bool? value = true)
	{
		Instance.IgnoreUnmapped = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, each search hit will contain inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor<TDocument> InnerHits(Elastic.Clients.Elasticsearch.Core.Search.InnerHits? value)
	{
		Instance.InnerHits = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, each search hit will contain inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor<TDocument> InnerHits()
	{
		Instance.InnerHits = Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, each search hit will contain inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor<TDocument> InnerHits(System.Action<Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument>>? action)
	{
		Instance.InnerHits = Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Name of the parent relationship mapped for the <c>join</c> field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor<TDocument> ParentType(string value)
	{
		Instance.ParentType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query you wish to run on parent documents of the <c>parent_type</c> field.
	/// If a parent document matches the search, the query returns its child documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor<TDocument> Query(Elastic.Clients.Elasticsearch.QueryDsl.Query value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query you wish to run on parent documents of the <c>parent_type</c> field.
	/// If a parent document matches the search, the query returns its child documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor<TDocument> Query(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether the relevance score of a matching parent document is aggregated into its child documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor<TDocument> Score(bool? value = true)
	{
		Instance.Score = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.HasParentQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.HasParentQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct HasParentQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.HasParentQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public HasParentQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.HasParentQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public HasParentQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.HasParentQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.HasParentQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.HasParentQuery(Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether to ignore an unmapped <c>parent_type</c> and not return any documents instead of an error.
	/// You can use this parameter to query multiple indices that may not contain the <c>parent_type</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor IgnoreUnmapped(bool? value = true)
	{
		Instance.IgnoreUnmapped = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, each search hit will contain inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor InnerHits(Elastic.Clients.Elasticsearch.Core.Search.InnerHits? value)
	{
		Instance.InnerHits = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, each search hit will contain inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor InnerHits()
	{
		Instance.InnerHits = Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, each search hit will contain inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor InnerHits(System.Action<Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor>? action)
	{
		Instance.InnerHits = Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, each search hit will contain inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor InnerHits<T>(System.Action<Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<T>>? action)
	{
		Instance.InnerHits = Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Name of the parent relationship mapped for the <c>join</c> field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor ParentType(string value)
	{
		Instance.ParentType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query you wish to run on parent documents of the <c>parent_type</c> field.
	/// If a parent document matches the search, the query returns its child documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor Query(Elastic.Clients.Elasticsearch.QueryDsl.Query value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query you wish to run on parent documents of the <c>parent_type</c> field.
	/// If a parent document matches the search, the query returns its child documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor Query(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Query you wish to run on parent documents of the <c>parent_type</c> field.
	/// If a parent document matches the search, the query returns its child documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor Query<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether the relevance score of a matching parent document is aggregated into its child documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor Score(bool? value = true)
	{
		Instance.Score = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.HasParentQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.HasParentQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.HasParentQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}